/**CFile***********************************************************************

  FileName    [ antReduce.c ]

  PackageName [ ant ]

  Synopsis    [ Simplification of the transition functions ]

  Description [ ]

  SeeAlso     []

  Author      [ David D&eacuteharbe ]

  Copyright   [ Carnegie Mellon University - 1996 ]

******************************************************************************/

#include "antInt.h" 

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Function**
  Synopsis           [ Reduce under care set ]
  Description        [ This routine reduces the BDD of the transition
  functions such that they remain equivalent when care holds. ]
  SideEffects        [ Modifies the internal state ]
**/
void ant_ReduceCareSet
(ant_manager t, bdd care)
{
  bdd_manager bddm = t->bddm;
  bdd * f;
  long i;
  for (i = 0, f = t->functions_map; i < t->functions_map_size; ++i, ++f) {
    do {
      bdd tmp = bdd_reduce(bddm, * f, care);
      if (bdd_overflow(bddm)) {
        bdd_resize_manager(bddm);
      } else {
        bdd_free(bddm, * f);
        * f = tmp;
        break;
      }
    } while (1);
  }
}

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Definition of static functions                                            */
/*---------------------------------------------------------------------------*/

