/**CHeaderFile*****************************************************************

  FileName    [ antInt.h ]

  PackageName [ ant ]

  Synopsis    [ Internal declarations ]

  Description [ ]

  SeeAlso     [ ant.h ]

  Author      [ David Deharbe ]

  Copyright   [ Carnegie Mellon University - 1996 ]
  Revision    [ 1.1 ]

******************************************************************************/

#ifndef _ANTINTH
#define _ANTINTH

#include "ant.h"

#include <memuser.h>
#include <bdd_up.h>
#include <cache.h>


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef struct ant_manager_rec_ ant_manager_rec;
typedef struct cache_entry_rec_ cache_entry_rec, * cache_entry; 

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/
struct cache_entry_rec_ {
  struct cache_entry_rec_ * link;
  bdd set;
  bdd ant;
};

struct ant_manager_rec_ {
  bdd_manager bddm;
  rec_mgr memory;
  cacheX_mgr cache;
  int var_assoc;
  bdd * functions_map;
  long functions_map_size;
};

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern bdd antGetFunction(ant_manager t, long id);

/**AutomaticEnd***************************************************************/

#endif /* _ANTINTH */

