/**CHeaderFile*****************************************************************

  FileName    [ ant.h ]

  PackageName [ ant ]

  Synopsis    [ BDD-based antecedent computation ]

  Description [ This library provides code to manage computations of
  antecedent (or inverse image) of a vector of transition functions. ]

  SeeAlso     [ img.h ]

  Author      [ David D&eacuteharbe ]

  Revision    [ 1 ]

  Copyright   [ Carnegie Mellon University - 1996 ]

******************************************************************************/

#ifndef _ANTH
#define _ANTH

#include <bdduser.h>
#include <vbdd.h>

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef struct ant_manager_rec_ * ant_manager;

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern ant_manager ant_New(bdd_manager bddm, vbdd variables, vbdd functions);
extern void ant_Free(ant_manager t);
extern void ant_Flush(ant_manager t);
extern bdd ant_Compute(const ant_manager t, bdd set);
extern void ant_ReduceCareSet(ant_manager t, bdd care);

/**AutomaticEnd***************************************************************/

#endif /* _ANTH */

