/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    cvc.h                                                     */
/*                                                              */
/* Description:                                                 */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

#if !defined(_CVCH)
#   define _CVCH

#include <ratc.h>
#include <bdduser.h>
#include <vbdd.h>
#include <vbdd_logic.h>
#include <vbdd_arith.h>
#include <cv.h>
#include <spec.h>
#include <model.h>
#include <label.h>
#include <timer.h>
#include <cache.h>

/* ----------------------------------------------- exit codes -- */
extern const int ERROR_EXIT_CODE;
extern const int SUCCESS_EXIT_CODE;

/* ------------------------------------------------------------ */
#define kSRType (unsigned) 0
#define kEnumType (unsigned) 1

/* ------------------------------------------------------------ */
cvn InitCondition ;

/* ------------------------------------------------------------ */

typedef struct expression_context_rec_ {
  rec_mgr id_rec_mgr, lit_rec_mgr, un_rec_mgr, bin_rec_mgr;
  cacheX_mgr id_cache, lit_cache, un_cache, bin_cache;
} expression_context_rec, * expression_context;

/* ------------------------------------------------------------ */

typedef struct cvc_context_rec_ {
  /* program parameters */
  int reorder_coeff;
  int size_mult_coeff;
  int opt_projection;
  int opt_scc;
  int opt_still_inputs;
  int opt_vhdl_testbench;
  int opt_witness_display;
  int opt_witness_counterexample;
  char * specification_name;
  FILE * outstream;
  struct {
    bdd_manager mgr;
    long node_limit;
  } bdd;
  Model model;
  expression_context expr_mgr;
  label_manager proof_label_mgr;
} cvc_context_rec, * cvc_context;

/* ------------------------------------------------------------ */

typedef struct {
  unsigned kind ;
  cvn node ;
  int offset ;
  unsigned range ;
} t_integer_type ;

typedef struct {
  unsigned kind;
  cvn node;
} t_enumeration_type ;

typedef union {
  t_integer_type int_t ;
  t_enumeration_type enum_t ;
} vhdl_type ;

/* coded_type is used to represent the informations associated to 
the representation of VHDL types. */
typedef struct coded_type_ {
  unsigned size ;
  bdd valid ;
  vbdd variables ;
  vbdd default_coding ;
} * coded_type ;

/* bdd_object is used to represent a VHDL object (signal, variable). */
typedef struct bdd_object_ {
  bdd valid;
  vbdd coding;
  vbdd default_coding;
} * bdd_object;

typedef struct bdd_value_ {
  vhdl_type type ;
  bdd valid ;
  vbdd coding ;
} * bdd_value ;

/* bddm is the manager needed by the bdd library */
extern bdd_manager bddm ;

/* ------------------------------------------------------------ */

extern void encode_init (void);
extern void encode_close (void);
extern coded_type encode_subtype (cvn);
extern bdd_value encode_constant (cvn);
extern bdd_value encode_object (cvn);
extern void bdd_value_free(bdd_value);
extern bdd_object encode_decl (cvn);
extern bdd_value * adjust_values (bdd_value, bdd_value);
extern int vhdl_type_equal (vhdl_type, vhdl_type);

/* ---------------------------------------- bdd_to_bdd_value -- */
extern bdd_value bdd_to_bdd_value (bdd);

/* -------------------------------------------- test & debug -- */
extern void elaborate_design_entity
   (cvc_context c, cvn design);
extern void elaborate_concurrent_statement
   (cvc_context c, cvn statement);
extern void elaborate_process_statement
   (cvc_context c, cvn process);
extern void elaborate_block_statement
   (cvc_context c, cvn block);

extern expression_context expression_init (void);
extern void expression_reset (expression_context);
extern void expression_finish (expression_context);
extern bdd_value expression_value (expression_context, cvn);
extern bdd condition_code (cvn, expression_context);

extern void add_identifier (Model m, cvn id);
extern void add_declarations (Model m, cvn decls);
extern void add_declaration (Model m, cvn decl);
extern void add_previous (Model m, cvn decl);
extern int is_previous (cvn decl);

extern unsigned CountBranches (cvn);

extern cvn ReduceExpression (cvn);

#endif _CVCH
