/* $Id: Parser.c,v 2.9 1992/08/07 15:28:42 grosch rel $ */

# define bool		char
# define true		1
# define false		0

# include "Parser.h"
# include "Errors.h"

# ifdef __cplusplus
extern "C" {
#    include "Memory.h"
#    include "DynArray.h"
#    include "Sets.h"
#    ifndef BCOPY
#       include <memory.h>
#    endif
}
# else
#    include "Memory.h"
#    include "DynArray.h"
#    include "Sets.h"
#    ifndef BCOPY
#       include <memory.h>
#    endif
# endif

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifdef lex_interface
#    define GetToken	yylex
     extern int yylex ();
#    ifndef AttributeDef
#	include "Positions.h"
        typedef struct { tPosition Position; } tScanAttribute;
        static	tScanAttribute	Attribute = {{ 0, 0 }};
#    endif
#    ifndef ErrorAttributeDef
#	define ErrorAttribute(Token, RepairAttribute)
#    endif
#    ifndef yyGetAttribute
#	define yyGetAttribute(yyAttrStackPtr, Attribute) * yyAttrStackPtr = yylval
#    endif
# else
#    include "Scanner.h"
#    ifndef yyGetAttribute
#	define yyGetAttribute(yyAttrStackPtr, Attribute) (yyAttrStackPtr)->Scan = Attribute
#    endif
# endif

/* line 2 "Parser.lalr" */


#include <Errors.h>
#include <cv.h>
#include <spec.h>

extern char * spec_name;
extern cvn spec_design;
extern spec_Node_t spec_abbreviations;
extern spec_Node_t spec_properties;
extern cvn spec_fairness;
extern cvn spec_invariant;
extern const int ERROR_EXIT_CODE;

typedef enum {invariant_k, fairness_k} assumption_t;


typedef struct { int value; } yyroot;
typedef struct { int value; } yyspecify_file;
typedef struct { int value; } yyspecification;
typedef struct { cvn node; } yydesign;
typedef struct { tString Id; } yyopt_identifier;
typedef struct { assumption_t type; cvn node; } yyassumption_aux;
typedef struct { cvn node; } yyinvariant;
typedef struct { cvn node; } yyrecurring;
typedef struct { tString Id; } yylabel;
typedef struct { ctl_term ctl; cvn vhdl; tPosition Position; } yyexpression;
typedef struct { ctl_term ctl; cvn vhdl; tPosition Position; } yytl_formula;
typedef struct { ctl_term ctl; cvn vhdl; tPosition Position; } yyrelation;
typedef struct { ctl_term ctl; cvn vhdl; tPosition Position; } yysimple_expression;
typedef struct { ctl_term ctl; cvn vhdl; tPosition Position; } yyprimary;
typedef struct { spec_Node_t node; } yycommitment;
typedef struct { spec_Operator_t key; ctl_term ctl; cvn vhdl; } yybinary_logical_operator;
typedef struct { spec_Operator_t key; } yymultiplying_logical_operator;
typedef struct { spec_Operator_t key; } yyunary_tl_operator;
typedef struct { spec_Operator_t key; ctl_term ctl; cvn vhdl; } yyrelational_operator;
typedef struct { spec_Operator_t key; } yyunary_logical_operator;

typedef union {
 tScanAttribute Scan;
 yyroot root;
 yyspecify_file specify_file;
 yyspecification specification;
 yydesign design;
 yyopt_identifier opt_identifier;
 yyassumption_aux assumption_aux;
 yyinvariant invariant;
 yyrecurring recurring;
 yylabel label;
 yyexpression expression;
 yytl_formula tl_formula;
 yyrelation relation;
 yysimple_expression simple_expression;
 yyprimary primary;
 yycommitment commitment;
 yybinary_logical_operator binary_logical_operator;
 yymultiplying_logical_operator multiplying_logical_operator;
 yyunary_tl_operator unary_tl_operator;
 yyrelational_operator relational_operator;
 yyunary_logical_operator unary_logical_operator;
} tParsAttribute;


# if defined lex_interface & ! defined yylvalDef
     tParsAttribute yylval;
# endif

# ifndef yyInitStackSize
#    define yyInitStackSize	100
# endif
# define yyNoState		0

# define yyFirstTerminal	0
# define yyLastTerminal		44
# define yyTableMax		129
# define yyNTableMax		195
# define yyFirstReadState	1
# define yyLastReadState	58
# define yyFirstReadTermState	59
# define yyLastReadTermState	95
# define yyLastReadNontermState	115
# define yyFirstReduceState	116
# define yyLastReduceState	183
# define yyStartState		1
# define yyStopState		116

# define yyFirstFinalState	yyFirstReadTermState

typedef unsigned short	yyStateRange	;
typedef unsigned short	yySymbolRange	;
typedef struct	{ yyStateRange Check, Next; } yyTCombType ;

	char *		Parser_TokenName	[yyLastTerminal + 1] = {
"_EndOfFile",
"identifier",
"character_literal",
"SPECIFICATION",
"OF",
"(",
")",
".",
"IS",
"ABBREVIATION",
"NOT",
"=",
"/=",
"<",
"<=",
">",
">=",
"EX",
"AX",
"EF",
"AF",
"EG",
"AG",
"E",
"[",
"U",
"]",
"W",
"A",
"@STABLE",
"AND",
"OR",
"XOR",
"XNOR",
"=>",
"NAND",
"NOR",
",",
";",
"COMMIT",
":",
"ASSUME",
"ALWAYS",
"RECURRING",
"END",
};
static	yyTCombType	yyTComb		[yyTableMax + 1] = {
{58, 116},
{2, 3},
{5, 6},
{1, 2},
{3, 120},
{4, 5},
{6, 7},
{7, 8},
{6, 9},
{8, 59},
{9, 10},
{10, 11},
{11, 12},
{12, 60},
{13, 121},
{14, 15},
{15, 128},
{16, 17},
{17, 18},
{18, 19},
{30, 63},
{39, 81},
{47, 90},
{0, 0},
{21, 22},
{23, 24},
{25, 26},
{27, 71},
{25, 32},
{31, 61},
{31, 62},
{33, 78},
{36, 79},
{31, 20},
{29, 156},
{34, 35},
{38, 80},
{34, 37},
{50, 91},
{29, 72},
{29, 73},
{29, 74},
{29, 75},
{29, 76},
{29, 77},
{40, 144},
{15, 128},
{16, 47},
{15, 128},
{16, 51},
{48, 49},
{15, 128},
{16, 55},
{29, 156},
{29, 156},
{29, 156},
{45, 46},
{45, 89},
{29, 156},
{29, 156},
{29, 156},
{29, 156},
{29, 156},
{29, 156},
{29, 156},
{29, 156},
{29, 156},
{44, 145},
{54, 92},
{40, 147},
{40, 147},
{40, 147},
{40, 147},
{40, 147},
{40, 82},
{40, 83},
{40, 144},
{40, 144},
{42, 84},
{42, 85},
{42, 86},
{42, 87},
{42, 88},
{51, 52},
{51, 53},
{55, 124},
{56, 94},
{55, 93},
{57, 95},
{0, 0},
{0, 0},
{44, 148},
{44, 148},
{44, 148},
{44, 148},
{44, 148},
{0, 0},
{0, 0},
{44, 145},
{44, 145},
{49, 64},
{49, 65},
{49, 66},
{49, 67},
{49, 68},
{49, 69},
{49, 21},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{49, 23},
{49, 70},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{55, 124},
{56, 126},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
};
static	unsigned short	yyNComb		[yyNTableMax - yyLastTerminal] = {
114,
58,
115,
4,
13,
14,
16,
56,
57,
110,
111,
112,
113,
45,
104,
102,
103,
0,
0,
48,
0,
40,
42,
43,
41,
96,
28,
29,
39,
99,
31,
30,
100,
0,
40,
42,
0,
0,
96,
28,
29,
34,
99,
31,
0,
96,
28,
29,
25,
99,
31,
0,
96,
28,
29,
27,
99,
31,
0,
96,
28,
29,
97,
99,
31,
0,
96,
28,
29,
0,
99,
31,
98,
33,
99,
31,
0,
96,
28,
29,
36,
99,
31,
0,
96,
28,
29,
38,
99,
31,
0,
96,
28,
29,
101,
99,
31,
0,
96,
28,
29,
44,
99,
31,
0,
96,
28,
29,
105,
99,
31,
0,
0,
50,
40,
42,
0,
0,
96,
28,
29,
106,
99,
31,
54,
108,
109,
40,
42,
0,
0,
96,
28,
29,
107,
99,
31,
0,
0,
0,
40,
42,
0,
0,
96,
28,
29,
0,
99,
31,
0,
};
static	yyTCombType *	yyTBasePtr	[yyLastReadState + 1] = {
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [1],
& yyTComb [1],
& yyTComb [1],
& yyTComb [6],
& yyTComb [3],
& yyTComb [9],
& yyTComb [6],
& yyTComb [11],
& yyTComb [7],
& yyTComb [6],
& yyTComb [7],
& yyTComb [7],
& yyTComb [8],
& yyTComb [17],
& yyTComb [11],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [1],
& yyTComb [0],
& yyTComb [1],
& yyTComb [0],
& yyTComb [1],
& yyTComb [0],
& yyTComb [28],
& yyTComb [10],
& yyTComb [28],
& yyTComb [0],
& yyTComb [5],
& yyTComb [10],
& yyTComb [0],
& yyTComb [6],
& yyTComb [0],
& yyTComb [10],
& yyTComb [15],
& yyTComb [39],
& yyTComb [0],
& yyTComb [48],
& yyTComb [0],
& yyTComb [61],
& yyTComb [19],
& yyTComb [0],
& yyTComb [21],
& yyTComb [10],
& yyTComb [83],
& yyTComb [0],
& yyTComb [41],
& yyTComb [0],
& yyTComb [0],
& yyTComb [30],
& yyTComb [84],
& yyTComb [85],
& yyTComb [50],
& yyTComb [0],
};
static	unsigned short*	yyNBasePtr	[yyLastReadState + 1] = {
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-32],
& yyNComb [-45],
& yyNComb [-25],
& yyNComb [-45],
& yyNComb [-18],
& yyNComb [-45],
& yyNComb [-11],
& yyNComb [-45],
& yyNComb [-4],
& yyNComb [-42],
& yyNComb [0],
& yyNComb [-42],
& yyNComb [7],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [14],
& yyNComb [-45],
& yyNComb [21],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [28],
& yyNComb [-45],
& yyNComb [35],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-43],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [48],
& yyNComb [-45],
& yyNComb [63],
& yyNComb [61],
& yyNComb [74],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
& yyNComb [-45],
};
static	unsigned short	yyDefault	[yyLastReadState + 1] = {
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
49,
49,
0,
49,
0,
49,
0,
49,
0,
49,
0,
31,
0,
49,
0,
0,
49,
0,
49,
0,
0,
0,
49,
0,
49,
0,
0,
17,
0,
0,
30,
0,
0,
49,
49,
0,
0,
0,
0,
0,
};
static	unsigned char	yyLength	[yyLastReduceState - yyFirstReduceState + 1] = {
2,
1,
1,
12,
0,
0,
4,
6,
0,
1,
0,
1,
0,
2,
1,
1,
1,
3,
1,
3,
3,
3,
1,
1,
2,
2,
5,
1,
1,
3,
3,
1,
3,
1,
2,
6,
6,
6,
6,
1,
1,
3,
1,
2,
1,
1,
3,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
};
static	yySymbolRange	yyLeftHandSide	[yyLastReduceState - yyFirstReduceState + 1] = {
76,
46,
45,
47,
48,
50,
49,
49,
52,
52,
53,
53,
51,
51,
54,
54,
54,
55,
58,
58,
59,
57,
61,
61,
62,
63,
56,
64,
60,
60,
60,
67,
67,
66,
66,
66,
66,
66,
66,
66,
70,
70,
72,
72,
74,
74,
74,
65,
69,
69,
68,
68,
68,
68,
68,
71,
71,
71,
71,
71,
71,
73,
73,
73,
73,
73,
73,
75,
};
static	yySymbolRange	yyContinuation	[yyLastReadState + 1] = {
0,
3,
1,
4,
4,
1,
5,
1,
6,
1,
5,
1,
6,
8,
8,
9,
44,
1,
8,
1,
1,
24,
1,
24,
1,
25,
1,
26,
1,
6,
1,
1,
1,
26,
25,
1,
26,
1,
26,
6,
6,
1,
30,
1,
6,
38,
1,
1,
40,
1,
38,
42,
1,
1,
38,
1,
38,
38,
0,
};
static	unsigned short	yyFinalToProd	[yyLastReadNontermState - yyFirstReadTermState + 1] = {
122,
123,
160,
161,
183,
171,
172,
173,
174,
175,
176,
155,
153,
177,
178,
179,
180,
181,
182,
154,
151,
152,
162,
164,
165,
166,
167,
168,
169,
170,
133,
143,
142,
137,
125,
127,
119,
149,
150,
157,
158,
159,
146,
136,
135,
134,
163,
140,
141,
138,
139,
129,
130,
131,
132,
117,
118,
};

static	void	yyErrorRecovery		ARGS((yySymbolRange * yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr));
static	void	yyComputeContinuation	ARGS((yyStateRange * yyStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyContinueSet));
static	bool	yyIsContinuation	ARGS((yySymbolRange yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr));
static	void	yyComputeRestartPoints	ARGS((yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyRestartSet));
static	yyStateRange yyNext		ARGS((yyStateRange yyState, yySymbolRange yySymbol));
static	void	BeginParser		();

int Parser ()
   {
      register	yyStateRange	yyState		;
      register	long		yyTerminal	;
      register	yyStateRange *	yyStateStackPtr ;
      register	tParsAttribute *yyAttrStackPtr	;
      register	bool		yyIsRepairing	;
		unsigned long	yyStateStackSize= yyInitStackSize;
		unsigned long	yyAttrStackSize = yyInitStackSize;
		yyStateRange *	yyStateStack	;
		tParsAttribute* yyAttributeStack;
		tParsAttribute	yySynAttribute	;	/* synthesized attribute */
      register	yyStateRange *	yyEndOfStack	;
		int		yyErrorCount	= 0;
   
/* line 68 "Parser.lalr" */



      BeginParser ();
      yyState		= yyStartState;
      yyTerminal	= GetToken ();
      MakeArray ((char * *) & yyStateStack, & yyStateStackSize, sizeof (yyStateRange));
      MakeArray ((char * *) & yyAttributeStack, & yyAttrStackSize, sizeof (tParsAttribute));
      yyEndOfStack	= & yyStateStack [yyStateStackSize];
      yyStateStackPtr	= yyStateStack;
      yyAttrStackPtr	= yyAttributeStack;
      yyIsRepairing	= false;

   ParseLoop:
      for (;;) {
	 if (yyStateStackPtr >= yyEndOfStack) {
	    int yyyStateStackPtr= yyStateStackPtr - yyStateStack;
	    int yyyAttrStackPtr	= yyAttrStackPtr - yyAttributeStack;
	    ExtendArray ((char * *) & yyStateStack, & yyStateStackSize, sizeof (yyStateRange));
	    ExtendArray ((char * *) & yyAttributeStack, & yyAttrStackSize, sizeof (tParsAttribute));
	    yyStateStackPtr	= yyStateStack + yyyStateStackPtr;
	    yyAttrStackPtr	= yyAttributeStack + yyyAttrStackPtr;
	    yyEndOfStack	= & yyStateStack [yyStateStackSize];
	 }
	 * yyStateStackPtr = yyState;

   TermTrans:
	 for (;;) {	/* SPEC State = Next (State, Terminal); terminal transition */
	    register short * yyTCombPtr;

	    yyTCombPtr = (short *) (yyTBasePtr [yyState] + yyTerminal);
	    if (* yyTCombPtr ++ == yyState) { yyState = * yyTCombPtr; break; }
	    if ((yyState = yyDefault [yyState]) != yyNoState) goto TermTrans;

							/* syntax error */
	    if (! yyIsRepairing) {			/* report and recover */
	       yySymbolRange yyyTerminal = yyTerminal;

	       yyErrorCount ++;
	       yyErrorRecovery (& yyyTerminal, yyStateStack, yyStateStackSize, yyStateStackPtr - yyStateStack);
	       yyTerminal = yyyTerminal;
	       yyIsRepairing = true;
	    }
	    yyState = * yyStateStackPtr;
	    for (;;) {
	       if (yyNext (yyState, (yySymbolRange) yyTerminal) == yyNoState) { /* repair */
		  yySymbolRange		yyRepairToken;
		  tScanAttribute	yyRepairAttribute;
	    
		  yyRepairToken = yyContinuation [yyState];
		  yyState = yyNext (yyState, yyRepairToken);
		  if (yyState <= yyLastReadTermState) { /* read or read terminal reduce ? */
		     ErrorAttribute ((int) yyRepairToken, & yyRepairAttribute);
		     ErrorMessageI (xxTokenInserted, xxRepair, Attribute.Position,
			xxString, Parser_TokenName [yyRepairToken]);
		     if (yyState >= yyFirstFinalState) {	/* avoid second push */
			yyState = yyFinalToProd [yyState - yyFirstReadTermState];
		     }
		     yyGetAttribute (yyAttrStackPtr ++, yyRepairAttribute);
		     * ++ yyStateStackPtr = yyState;
		  }
		  if (yyState >= yyFirstFinalState) goto Final; /* final state ? */
	       } else {
		  yyState = yyNext (yyState, (yySymbolRange) yyTerminal);
		  goto Final;
	       }
	    }
	 }

   Final:
	 if (yyState >= yyFirstFinalState) {		/* final state ? */
	    if (yyState <= yyLastReadTermState) {	/* read terminal reduce ? */
	       yyStateStackPtr ++;
	       yyGetAttribute (yyAttrStackPtr ++, Attribute);
	       yyTerminal = GetToken ();
	       yyIsRepairing = false;
	    }

	    for (;;) {
	       /* register long yyNonterminal;		/* left-hand side */
# define yyNonterminal yyState

switch (yyState) {
case 116: /* _0000_ : root _EndOfFile .*/
  ReleaseArray ((char * *) & yyStateStack, & yyStateStackSize, sizeof (yyStateRange));
  ReleaseArray ((char * *) & yyAttributeStack, & yyAttrStackSize, sizeof (tParsAttribute));
  return yyErrorCount;

case 117:
case 114: /* root : specify_file .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 46; {

} break;
case 118:
case 115: /* specify_file : specification .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 45; {

} break;
case 119:
case 95: /* specification : 'SPECIFICATION' identifier xx1 'OF' design xx2 'IS' declarations 'END' opt_specification opt_identifier ';' .*/
  yyStateStackPtr -=12; yyAttrStackPtr -=12; yyNonterminal = 47; {

} break;
case 120: /* xx1 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 48; {
/* line 132 "Parser.lalr" */
 ;
{  
      spec_design_library = 0;
      spec_design = 0;
      spec_abbreviations = 0;
      spec_properties = 0;
      spec_fairness = 0;
      spec_invariant = 0;
      spec_name = yyAttrStackPtr [0-1].Scan.identifier.Id;
     }
  ;

} break;
case 121: /* xx2 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 50; {
/* line 144 "Parser.lalr" */
 yySynAttribute.specification = yyAttrStackPtr [-2-1].specification;

    ;
{ 
      if (NullNode(spec_design)) {
        exit(ERROR_EXIT_CODE);
      }
     }
  ;

} break;
case 122:
case 59: /* design : identifier '(' identifier ')' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 49; {
/* line 155 "Parser.lalr" */

    yySynAttribute.design.node= spec_ActionLoadDesign("work", yyAttrStackPtr [1-1].Scan.identifier.Id, yyAttrStackPtr [3-1].Scan.identifier.Id, yySynAttribute.Scan.Position);

  ;

} break;
case 123:
case 60: /* design : identifier '.' identifier '(' identifier ')' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 49; {
/* line 159 "Parser.lalr" */

    yySynAttribute.design.node= spec_ActionLoadDesign(yyAttrStackPtr [1-1].Scan.identifier.Id, yyAttrStackPtr [3-1].Scan.identifier.Id, yyAttrStackPtr [5-1].Scan.identifier.Id, yySynAttribute.Scan.Position);

  ;

} break;
case 124: /* opt_specification : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 52; {

} break;
case 125:
case 93: /* opt_specification : 'SPECIFICATION' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 52; {

} break;
case 126: /* opt_identifier : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 53; {
/* line 166 "Parser.lalr" */
  
			yySynAttribute.opt_identifier.Id = (char *) NULL;
  
		;

} break;
case 127:
case 94: /* opt_identifier : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 53; {
/* line 171 "Parser.lalr" */

			yySynAttribute.opt_identifier.Id =  yyAttrStackPtr [1-1].Scan.identifier.Id;

		;

} break;
case 128: /* declarations : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 51; {

} break;
case 129:
case 110: /* declarations : declarations declarative_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 51; {

} break;
case 130:
case 111: /* declarative_item : abbreviations .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 54; {

} break;
case 131:
case 112: /* declarative_item : property .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 54; {

} break;
case 132:
case 113: /* declarative_item : assumption .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 54; {

} break;
case 133:
case 89: /* abbreviations : 'ABBREVIATION' abbreviation_list ';' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 55; {

} break;
case 134:
case 104: /* abbreviation_list : abbreviation .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 58; {

} break;
case 135:
case 103: /* abbreviation_list : abbreviation_list ',' abbreviation .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 58; {

} break;
case 136:
case 102: /* abbreviation : identifier 'IS' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 59; {
/* line 184 "Parser.lalr" */
 ;
{ 
      (void) spec_ActionCheckAbbreviation(yyAttrStackPtr [1-1].Scan.identifier.Id, &yyErrorCount,
                                          yyAttrStackPtr [1-1].Scan.Position);
      spec_abbreviations= 
        spec_BasicAppend(spec_abbreviations,
          spec_BasicNew(0, yyAttrStackPtr [1-1].Scan.identifier.Id, 0, yyAttrStackPtr [3-1].expression.vhdl));
     }
  ;

} break;
case 137:
case 92: /* assumption : 'ASSUME' assumption_aux ';' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 57; {
/* line 194 "Parser.lalr" */

    ;
{ 
      if (yyAttrStackPtr [2-1].assumption_aux.type == invariant_k) {
        sPrevious(spec_invariant, yyAttrStackPtr [2-1].assumption_aux.node);
        sNext(yyAttrStackPtr [2-1].assumption_aux.node, spec_invariant);
        spec_invariant = yyAttrStackPtr [2-1].assumption_aux.node;
      } else {
        sPrevious(spec_fairness, yyAttrStackPtr [2-1].assumption_aux.node);
        sNext(yyAttrStackPtr [2-1].assumption_aux.node, spec_fairness);
        spec_fairness = yyAttrStackPtr [2-1].assumption_aux.node;
      }
     }
  ;

} break;
case 138:
case 108: /* assumption_aux : invariant .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 61; {
/* line 209 "Parser.lalr" */

      yySynAttribute.assumption_aux.type= invariant_k;

      yySynAttribute.assumption_aux.node= mList(0, 0, 0, yyAttrStackPtr [1-1].invariant.node);

    ;

} break;
case 139:
case 109: /* assumption_aux : recurring .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 61; {
/* line 216 "Parser.lalr" */

      yySynAttribute.assumption_aux.type= fairness_k;

      yySynAttribute.assumption_aux.node= mList(0, 0, 0, yyAttrStackPtr [1-1].recurring.node);

    ;

} break;
case 140:
case 106: /* invariant : 'ALWAYS' expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 62; {
/* line 223 "Parser.lalr" */

    ;
{ 
       spec_ActionCheckCondition(yyAttrStackPtr [2-1].expression.vhdl,
                                 & yyErrorCount,
                                 yyAttrStackPtr [2-1].expression.Position) ;
     }
    yySynAttribute.invariant.node  =  yyAttrStackPtr [2-1].expression.vhdl;

  ;

} break;
case 141:
case 107: /* recurring : 'RECURRING' expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 63; {
/* line 234 "Parser.lalr" */

    ;
{ 
       spec_ActionCheckCondition(yyAttrStackPtr [2-1].expression.vhdl,
                                 & yyErrorCount,
                                 yyAttrStackPtr [2-1].expression.Position) ;
     }
    yySynAttribute.recurring.node  =  yyAttrStackPtr [2-1].expression.vhdl;

  ;

} break;
case 142:
case 91: /* property : 'COMMIT' label ':' commitment ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 56; {
/* line 245 "Parser.lalr" */
 
  ;
{ 
    spec_BasicSName(yyAttrStackPtr [4-1].commitment.node, yyAttrStackPtr [2-1].label.Id);
    spec_properties = spec_BasicAppend(spec_properties, yyAttrStackPtr [4-1].commitment.node);
     }
  ;

} break;
case 143:
case 90: /* label : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 64; {
/* line 253 "Parser.lalr" */

  yySynAttribute.label.Id  =  yyAttrStackPtr [1-1].Scan.identifier.Id;

;

} break;
case 144: /* expression : tl_formula .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 60; {
/* line 258 "Parser.lalr" */

      yySynAttribute.expression.ctl = yyAttrStackPtr [1-1].tl_formula.ctl;

      yySynAttribute.expression.vhdl = yyAttrStackPtr [1-1].tl_formula.vhdl;

      yySynAttribute.expression.Position = yyAttrStackPtr [1-1].tl_formula.Position;

    ;

} break;
case 145: /* expression : multiplying_expression multiplying_logical_operator tl_formula .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 60; {
/* line 267 "Parser.lalr" */

      yySynAttribute.expression.ctl=
        spec_ActionBinaryCTLTerm(yyAttrStackPtr [2-1].multiplying_logical_operator.key, yyAttrStackPtr [1-1].expression.ctl, yyAttrStackPtr [1-1].expression.vhdl,
                                 yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                                 &yyErrorCount, yyAttrStackPtr [1-1].expression.Position);

      yySynAttribute.expression.vhdl=
        spec_ActionBinaryVHDLTerm(yyAttrStackPtr [2-1].multiplying_logical_operator.key, yyAttrStackPtr [1-1].expression.ctl, yyAttrStackPtr [1-1].expression.vhdl,
                                  yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                                  &yyErrorCount, yyAttrStackPtr [1-1].expression.Position);

      yySynAttribute.expression.Position = yyAttrStackPtr [1-1].expression.Position;

    ;

} break;
case 146:
case 101: /* expression : tl_formula binary_logical_operator tl_formula .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 60; {
/* line 282 "Parser.lalr" */

    yySynAttribute.expression.ctl=
      spec_ActionBinaryCTLTerm(yyAttrStackPtr [2-1].binary_logical_operator.key, yyAttrStackPtr [1-1].tl_formula.ctl, yyAttrStackPtr [1-1].tl_formula.vhdl,
                               yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                               &yyErrorCount, yyAttrStackPtr [1-1].tl_formula.Position);

    yySynAttribute.expression.vhdl=
      spec_ActionBinaryVHDLTerm(yyAttrStackPtr [2-1].binary_logical_operator.key, yyAttrStackPtr [1-1].tl_formula.ctl, yyAttrStackPtr [1-1].tl_formula.vhdl,
                                yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                                &yyErrorCount, yyAttrStackPtr [1-1].tl_formula.Position);

    yySynAttribute.expression.Position = yyAttrStackPtr [1-1].tl_formula.Position;

  ;

} break;
case 147: /* multiplying_expression : tl_formula .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 67; {
/* line 297 "Parser.lalr" */

      yySynAttribute.expression.ctl = yyAttrStackPtr [1-1].tl_formula.ctl;

      yySynAttribute.expression.vhdl = yyAttrStackPtr [1-1].tl_formula.vhdl;

      yySynAttribute.expression.Position = yyAttrStackPtr [1-1].tl_formula.Position;

    ;

} break;
case 148: /* multiplying_expression : multiplying_expression multiplying_logical_operator tl_formula .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 67; {
/* line 306 "Parser.lalr" */

      yySynAttribute.expression.ctl=
        spec_ActionBinaryCTLTerm(yyAttrStackPtr [2-1].multiplying_logical_operator.key, yyAttrStackPtr [1-1].expression.ctl, yyAttrStackPtr [1-1].expression.vhdl,
                                 yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                                 &yyErrorCount, yyAttrStackPtr [1-1].expression.Position);

      yySynAttribute.expression.vhdl=
        spec_ActionBinaryVHDLTerm(yyAttrStackPtr [2-1].multiplying_logical_operator.key, yyAttrStackPtr [1-1].expression.ctl, yyAttrStackPtr [1-1].expression.vhdl,
                                  yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                                  &yyErrorCount, yyAttrStackPtr [1-1].expression.Position);

      yySynAttribute.expression.Position = yyAttrStackPtr [1-1].expression.Position;

    ;

} break;
case 149:
case 96: /* tl_formula : relation .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 66; {
/* line 321 "Parser.lalr" */

    yySynAttribute.tl_formula.ctl = yyAttrStackPtr [1-1].relation.ctl;

    yySynAttribute.tl_formula.vhdl = yyAttrStackPtr [1-1].relation.vhdl;

    yySynAttribute.tl_formula.Position = yyAttrStackPtr [1-1].relation.Position;

  ;

} break;
case 150:
case 97: /* tl_formula : unary_tl_operator tl_formula .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 66; {
/* line 330 "Parser.lalr" */

    yySynAttribute.tl_formula.ctl=
      spec_ActionUnaryCTLTerm(yyAttrStackPtr [1-1].unary_tl_operator.key, yyAttrStackPtr [2-1].tl_formula.ctl, yyAttrStackPtr [2-1].tl_formula.vhdl,
                               &yyErrorCount, yyAttrStackPtr [2-1].tl_formula.Position);

    yySynAttribute.tl_formula.vhdl=
      spec_ActionUnaryVHDLTerm(yyAttrStackPtr [1-1].unary_tl_operator.key, yyAttrStackPtr [2-1].tl_formula.ctl, yyAttrStackPtr [2-1].tl_formula.vhdl,
                               &yyErrorCount, yyAttrStackPtr [2-1].tl_formula.Position);

    yySynAttribute.tl_formula.Position = yyAttrStackPtr [2-1].tl_formula.Position;

  ;

} break;
case 151:
case 79: /* tl_formula : 'E' '[' tl_formula 'U' tl_formula ']' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 66; {
/* line 343 "Parser.lalr" */

    yySynAttribute.tl_formula.ctl=
      spec_ActionBinaryCTLTerm(spec_EU, yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                               yyAttrStackPtr [5-1].tl_formula.ctl, yyAttrStackPtr [5-1].tl_formula.vhdl,
                               &yyErrorCount, yyAttrStackPtr [3-1].tl_formula.Position);

    yySynAttribute.tl_formula.vhdl=0;

    yySynAttribute.tl_formula.Position = yyAttrStackPtr [3-1].tl_formula.Position;

  ;

} break;
case 152:
case 80: /* tl_formula : 'E' '[' tl_formula 'W' tl_formula ']' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 66; {
/* line 355 "Parser.lalr" */

    yySynAttribute.tl_formula.ctl=
      spec_ActionBinaryCTLTerm(spec_EW, yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                               yyAttrStackPtr [5-1].tl_formula.ctl, yyAttrStackPtr [5-1].tl_formula.vhdl,
                               &yyErrorCount, yyAttrStackPtr [3-1].tl_formula.Position);

    yySynAttribute.tl_formula.vhdl=0;

    yySynAttribute.tl_formula.Position = yyAttrStackPtr [3-1].tl_formula.Position;

  ;

} break;
case 153:
case 71: /* tl_formula : 'A' '[' tl_formula 'U' tl_formula ']' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 66; {
/* line 367 "Parser.lalr" */

    yySynAttribute.tl_formula.ctl=
      spec_ActionBinaryCTLTerm(spec_AU, yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                               yyAttrStackPtr [5-1].tl_formula.ctl, yyAttrStackPtr [5-1].tl_formula.vhdl,
                               &yyErrorCount, yyAttrStackPtr [3-1].tl_formula.Position);

    yySynAttribute.tl_formula.vhdl=0;

    yySynAttribute.tl_formula.Position = yyAttrStackPtr [3-1].tl_formula.Position;

  ;

} break;
case 154:
case 78: /* tl_formula : 'A' '[' tl_formula 'W' tl_formula ']' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 66; {
/* line 379 "Parser.lalr" */

    yySynAttribute.tl_formula.ctl=
      spec_ActionBinaryCTLTerm(spec_AW, yyAttrStackPtr [3-1].tl_formula.ctl, yyAttrStackPtr [3-1].tl_formula.vhdl,
                               yyAttrStackPtr [5-1].tl_formula.ctl, yyAttrStackPtr [5-1].tl_formula.vhdl,
                               &yyErrorCount, yyAttrStackPtr [3-1].tl_formula.Position);

    yySynAttribute.tl_formula.vhdl=0;

    yySynAttribute.tl_formula.Position = yyAttrStackPtr [3-1].tl_formula.Position;

  ;

} break;
case 155:
case 70: /* tl_formula : '@STABLE' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 66; {
/* line 391 "Parser.lalr" */
yySynAttribute.tl_formula.Position = yyAttrStackPtr [1-1].Scan.Position;

    yySynAttribute.tl_formula.ctl=
      spec_ActionMacroCTLTerm(spec_Stable, &yyErrorCount, yySynAttribute.tl_formula.Position);

    yySynAttribute.tl_formula.vhdl=0;

  ;

} break;
case 156: /* relation : simple_expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 70; {
/* line 400 "Parser.lalr" */

    yySynAttribute.relation.ctl =  yyAttrStackPtr [1-1].simple_expression.ctl ;

    yySynAttribute.relation.vhdl =  yyAttrStackPtr [1-1].simple_expression.vhdl ;

    yySynAttribute.relation.Position = yyAttrStackPtr [1-1].simple_expression.Position;

  ;

} break;
case 157:
case 98: /* relation : simple_expression relational_operator simple_expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 70; {
/* line 409 "Parser.lalr" */

    yySynAttribute.relation.ctl=     
      spec_ActionBinaryCTLTerm(yyAttrStackPtr [2-1].relational_operator.key, yyAttrStackPtr [1-1].simple_expression.ctl, yyAttrStackPtr [1-1].simple_expression.vhdl,
                               yyAttrStackPtr [3-1].simple_expression.ctl, yyAttrStackPtr [3-1].simple_expression.vhdl,
                               &yyErrorCount, yyAttrStackPtr [1-1].simple_expression.Position);

    yySynAttribute.relation.vhdl=
      spec_ActionBinaryVHDLTerm(yyAttrStackPtr [2-1].relational_operator.key, yyAttrStackPtr [1-1].simple_expression.ctl, yyAttrStackPtr [1-1].simple_expression.vhdl,
                                 yyAttrStackPtr [3-1].simple_expression.ctl, yyAttrStackPtr [3-1].simple_expression.vhdl,
                                 &yyErrorCount, yyAttrStackPtr [1-1].simple_expression.Position);

    yySynAttribute.relation.Position = yyAttrStackPtr [1-1].simple_expression.Position;

  ;

} break;
case 158:
case 99: /* simple_expression : primary .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 72; {
/* line 424 "Parser.lalr" */

    yySynAttribute.simple_expression.ctl = yyAttrStackPtr [1-1].primary.ctl;

    yySynAttribute.simple_expression.vhdl = yyAttrStackPtr [1-1].primary.vhdl;

    yySynAttribute.simple_expression.Position = yyAttrStackPtr [1-1].primary.Position;

  ;

} break;
case 159:
case 100: /* simple_expression : unary_logical_operator primary .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 72; {
/* line 433 "Parser.lalr" */

    yySynAttribute.simple_expression.ctl=
      spec_ActionUnaryCTLTerm(yyAttrStackPtr [1-1].unary_logical_operator.key, yyAttrStackPtr [2-1].primary.ctl, yyAttrStackPtr [2-1].primary.vhdl,
                              &yyErrorCount, yyAttrStackPtr [2-1].primary.Position);

    yySynAttribute.simple_expression.vhdl=
      spec_ActionUnaryVHDLTerm(yyAttrStackPtr [1-1].unary_logical_operator.key, yyAttrStackPtr [2-1].primary.ctl, yyAttrStackPtr [2-1].primary.vhdl,
                              &yyErrorCount, yyAttrStackPtr [2-1].primary.Position);

    yySynAttribute.simple_expression.Position = yyAttrStackPtr [2-1].primary.Position;

  ;

} break;
case 160:
case 61: /* primary : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 74; {
/* line 446 "Parser.lalr" */

    yySynAttribute.primary.ctl = 0;

    yySynAttribute.primary.vhdl = 
      spec_ActionIdentifierTerm(yyAttrStackPtr [1-1].Scan.identifier.Id, &yyErrorCount, yyAttrStackPtr [1-1].Scan.Position);

    yySynAttribute.primary.Position = yyAttrStackPtr [1-1].Scan.Position;

  ;

} break;
case 161:
case 62: /* primary : character_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 74; {
/* line 456 "Parser.lalr" */

    yySynAttribute.primary.ctl=0;

    yySynAttribute.primary.vhdl =
      spec_ActionCharLiteralTerm(yyAttrStackPtr [1-1].Scan.character_literal.Val,
                                 &yyErrorCount, yyAttrStackPtr [1-1].Scan.Position);

    yySynAttribute.primary.Position = yyAttrStackPtr [1-1].Scan.Position;

  ;

} break;
case 162:
case 81: /* primary : '(' expression ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 74; {
/* line 467 "Parser.lalr" */

    yySynAttribute.primary.ctl  =  yyAttrStackPtr [2-1].expression.ctl;

    yySynAttribute.primary.vhdl  =  yyAttrStackPtr [2-1].expression.vhdl;

    yySynAttribute.primary.Position = yyAttrStackPtr [2-1].expression.Position;

  ;

} break;
case 163:
case 105: /* commitment : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 65; {
/* line 476 "Parser.lalr" */

    ;
{ 
      spec_ActionCheckCondition(yyAttrStackPtr [1-1].expression.vhdl,
                                & yyErrorCount,
                                yyAttrStackPtr [1-1].expression.Position) ;
     }
    yySynAttribute.commitment.node = spec_BasicNew(0, 0, 0, yyAttrStackPtr [1-1].expression.ctl ? yyAttrStackPtr [1-1].expression.ctl :
                          ctl_BasicNew(0, 0, ctl_AtomicTerm, yyAttrStackPtr [1-1].expression.vhdl));

  ;

} break;
case 164:
case 82: /* binary_logical_operator : 'NAND' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 69; {
/* line 488 "Parser.lalr" */
 yySynAttribute.binary_logical_operator.key=spec_Nand;
 ;

} break;
case 165:
case 83: /* binary_logical_operator : 'NOR' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 69; {
/* line 491 "Parser.lalr" */
 yySynAttribute.binary_logical_operator.key=spec_Nor;
 ;

} break;
case 166:
case 84: /* multiplying_logical_operator : 'AND' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 68; {
/* line 494 "Parser.lalr" */
 yySynAttribute.multiplying_logical_operator.key=spec_And;
 ;

} break;
case 167:
case 85: /* multiplying_logical_operator : 'OR' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 68; {
/* line 497 "Parser.lalr" */
 yySynAttribute.multiplying_logical_operator.key=spec_Or;
 ;

} break;
case 168:
case 86: /* multiplying_logical_operator : 'XOR' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 68; {
/* line 500 "Parser.lalr" */
 yySynAttribute.multiplying_logical_operator.key=spec_Xor;
 ;

} break;
case 169:
case 87: /* multiplying_logical_operator : 'XNOR' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 68; {
/* line 503 "Parser.lalr" */
 yySynAttribute.multiplying_logical_operator.key=spec_Xnor;
 ;

} break;
case 170:
case 88: /* multiplying_logical_operator : '=>' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 68; {
/* line 506 "Parser.lalr" */
 yySynAttribute.multiplying_logical_operator.key=spec_Implies;
 ;

} break;
case 171:
case 64: /* unary_tl_operator : 'EX' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 71; {
/* line 509 "Parser.lalr" */
 yySynAttribute.unary_tl_operator.key= spec_EX;
 ;

} break;
case 172:
case 65: /* unary_tl_operator : 'AX' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 71; {
/* line 512 "Parser.lalr" */
 yySynAttribute.unary_tl_operator.key= spec_AX;
 ;

} break;
case 173:
case 66: /* unary_tl_operator : 'EF' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 71; {
/* line 515 "Parser.lalr" */
 yySynAttribute.unary_tl_operator.key= spec_EF;
 ;

} break;
case 174:
case 67: /* unary_tl_operator : 'AF' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 71; {
/* line 518 "Parser.lalr" */
 yySynAttribute.unary_tl_operator.key= spec_AF;
 ;

} break;
case 175:
case 68: /* unary_tl_operator : 'EG' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 71; {
/* line 521 "Parser.lalr" */
 yySynAttribute.unary_tl_operator.key= spec_EG;
 ;

} break;
case 176:
case 69: /* unary_tl_operator : 'AG' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 71; {
/* line 524 "Parser.lalr" */
 yySynAttribute.unary_tl_operator.key= spec_AG;
 ;

} break;
case 177:
case 72: /* relational_operator : '=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 73; {
/* line 527 "Parser.lalr" */
 yySynAttribute.relational_operator.key=spec_Eq;
 ;

} break;
case 178:
case 73: /* relational_operator : '/=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 73; {
/* line 530 "Parser.lalr" */
 yySynAttribute.relational_operator.key=spec_Neq;
 ;

} break;
case 179:
case 74: /* relational_operator : '<' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 73; {
/* line 533 "Parser.lalr" */
 yySynAttribute.relational_operator.key=spec_Lt;
 ;

} break;
case 180:
case 75: /* relational_operator : '<=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 73; {
/* line 536 "Parser.lalr" */
 yySynAttribute.relational_operator.key=spec_Le;
 ;

} break;
case 181:
case 76: /* relational_operator : '>' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 73; {
/* line 539 "Parser.lalr" */
 yySynAttribute.relational_operator.key=spec_Gt;
 ;

} break;
case 182:
case 77: /* relational_operator : '>=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 73; {
/* line 542 "Parser.lalr" */
 yySynAttribute.relational_operator.key=spec_Ge;
 ;

} break;
case 183:
case 63: /* unary_logical_operator : 'NOT' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 75; {
/* line 545 "Parser.lalr" */
 yySynAttribute.unary_logical_operator.key=spec_Not;
 ;

} break;
}

	       /* SPEC State = Next (Top (), Nonterminal); nonterminal transition */
	       yyState = * (yyNBasePtr [* yyStateStackPtr ++] + yyNonterminal);
	       * yyAttrStackPtr ++ = yySynAttribute;
	       if (yyState < yyFirstFinalState) goto ParseLoop; /* read nonterminal reduce ? */
	    } 

	 } else {					/* read */
	    yyStateStackPtr ++;
	    yyGetAttribute (yyAttrStackPtr ++, Attribute);
	    yyTerminal = GetToken ();
	    yyIsRepairing = false;
	 }
      }
   }

static void yyErrorRecovery
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange * yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr)
# else
   (yyTerminal, yyStateStack, yyStackSize, yyStackPtr)
   yySymbolRange *	yyTerminal	;
   yyStateRange *	yyStateStack	;
   unsigned long	yyStackSize	;
   short		yyStackPtr	;
# endif
   {
      bool	yyTokensSkipped	;
      tSet	yyContinueSet	;
      tSet	yyRestartSet	;
      int	yyLength = 0	;
      char	yyContinueString [256];

   /* 1. report an error */
      ErrorMessage (xxSyntaxError, xxError, Attribute.Position);

   /* 2. report the set of expected terminal symbols */
      MakeSet (& yyContinueSet, (short) yyLastTerminal);
      yyComputeContinuation (yyStateStack, yyStackSize, yyStackPtr, & yyContinueSet);
      yyContinueString [0] = '\0';
      while (! IsEmpty (& yyContinueSet)) {
	 char * yyTokenString = Parser_TokenName [Extract (& yyContinueSet)];
	 if ((yyLength += strlen (yyTokenString) + 1) >= 256) break;
	 (void) strcat (yyContinueString, yyTokenString);
	 (void) strcat (yyContinueString, " ");
      }
      ErrorMessageI (xxExpectedTokens, xxInformation, Attribute.Position,
	 xxString, yyContinueString);
      ReleaseSet (& yyContinueSet);

   /* 3. compute the set of terminal symbols for restart of the parse */
      MakeSet (& yyRestartSet, (short) yyLastTerminal);
      yyComputeRestartPoints (yyStateStack, yyStackSize, yyStackPtr, & yyRestartSet);

   /* 4. skip terminal symbols until a restart point is reached */
      yyTokensSkipped = false;
      while (! IsElement (* yyTerminal, & yyRestartSet)) {
	 * yyTerminal = GetToken ();
	 yyTokensSkipped = true;
      }
      ReleaseSet (& yyRestartSet);

   /* 5. report the restart point */
      if (yyTokensSkipped) {
	 ErrorMessage (xxRestartPoint, xxInformation, Attribute.Position);
      }
   }

/*
   compute the set of terminal symbols that can be accepted (read)
   in a given stack configuration (eventually after reduce actions)
*/

static void yyComputeContinuation
# if defined __STDC__ | defined __cplusplus
   (yyStateRange * yyStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyContinueSet)
# else
   (yyStack, yyStackSize, yyStackPtr, yyContinueSet)
   yyStateRange *	yyStack		;
   unsigned long	yyStackSize	;
   short		yyStackPtr	;
   tSet *		yyContinueSet	;
# endif
   {
      register yySymbolRange	yyTerminal;
      register yyStateRange	yyState = yyStack [yyStackPtr];

      AssignEmpty (yyContinueSet);
      for (yyTerminal = yyFirstTerminal; yyTerminal <= yyLastTerminal; yyTerminal ++) {
	 if (yyNext (yyState, yyTerminal) != yyNoState &&
	    yyIsContinuation (yyTerminal, yyStack, yyStackSize, yyStackPtr)) {
	    Include (yyContinueSet, (short) yyTerminal);
	 }
      }
   }

/*
   check whether a given terminal symbol can be accepted (read)
   in a certain stack configuration (eventually after reduce actions)
*/

static bool yyIsContinuation
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr)
# else
   (yyTerminal, yyStateStack, yyStackSize, yyStackPtr)
   yySymbolRange	yyTerminal	;
   yyStateRange *	yyStateStack	;
   unsigned long	yyStackSize	;
   short		yyStackPtr	;
# endif
   {
      register yyStateRange	yState		;
      register yySymbolRange	yyNonterminal	;
	       yyStateRange *	yyStack		;
   
      MakeArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));	/* pass Stack by value */
# ifdef BCOPY
      bcopy ((char *) yyStateStack, (char *) yyStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# else
      (void) memcpy ((char *) yyStack, (char *) yyStateStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# endif

      yState = yyStack [yyStackPtr];
      for (;;) {
	 yyStack [yyStackPtr] = yState;
	 yState = yyNext (yState, yyTerminal);
	 if (yState == yyNoState) {
	    ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	    return false;
	 }
	 if (yState <= yyLastReadTermState) {		/* read or read terminal reduce ? */
	    ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	    return true;
	 }

	 for (;;) {					/* reduce */
	    if (yState == yyStopState) {
	       ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	       return true;
	    } else { 
	       yyStackPtr -= yyLength [yState - yyFirstReduceState];
	       yyNonterminal = yyLeftHandSide [yState - yyFirstReduceState];
	    }

	    yState = yyNext (yyStack [yyStackPtr], yyNonterminal);
	    if (yyStackPtr >= yyStackSize) {
	       ExtendArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	    }
	    yyStackPtr ++;
	    if (yState < yyFirstFinalState) break;	/* read nonterminal ? */
	    yState = yyFinalToProd [yState - yyFirstReadTermState];	/* read nonterminal reduce */
	 }
      }
   }

/*
   compute a set of terminal symbols that can be used to restart
   parsing in a given stack configuration. we simulate parsing until
   end of file using a suffix program synthesized by the function
   Continuation. All symbols acceptable in the states reached during
   the simulation can be used to restart parsing.
*/

static void yyComputeRestartPoints
# if defined __STDC__ | defined __cplusplus
   (yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyRestartSet)
# else
   (yyStateStack, yyStackSize, yyStackPtr, yyRestartSet)
   yyStateRange *	yyStateStack	;
   unsigned long	yyStackSize	;
   short		yyStackPtr	;
   tSet *		yyRestartSet	;
# endif
   {
      register yyStateRange	yState		;
      register yySymbolRange	yyNonterminal	;
	       yyStateRange *	yyStack		;
	       tSet		yyContinueSet	;
   
      MakeArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange)); /* pass Stack by value */
# ifdef BCOPY
      bcopy ((char *) yyStateStack, (char *) yyStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# else
      (void) memcpy ((char *) yyStack, (char *) yyStateStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# endif

      MakeSet (& yyContinueSet, (short) yyLastTerminal);
      AssignEmpty (yyRestartSet);
      yState = yyStack [yyStackPtr];

      for (;;) {
	 if (yyStackPtr >= yyStackSize) {
	    ExtendArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	 }
	 yyStack [yyStackPtr] = yState;
	 yyComputeContinuation (yyStack, yyStackSize, yyStackPtr, & yyContinueSet);
	 Union (yyRestartSet, & yyContinueSet);
	 yState = yyNext (yState, yyContinuation [yState]);

	 if (yState >= yyFirstFinalState) {		/* final state ? */
	    if (yState <= yyLastReadTermState) {	/* read terminal reduce ? */
	       yyStackPtr ++;
	       yState = yyFinalToProd [yState - yyFirstReadTermState];
	    }

	    for (;;) {					/* reduce */
	       if (yState == yyStopState) {
		  ReleaseSet (& yyContinueSet);
		  ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
		  return;
	       } else { 
		  yyStackPtr -= yyLength [yState - yyFirstReduceState];
		  yyNonterminal = yyLeftHandSide [yState - yyFirstReduceState];
	       }

	       yState = yyNext (yyStack [yyStackPtr], yyNonterminal);
	       yyStackPtr ++;
	       if (yState < yyFirstFinalState) break;	/* read nonterminal ? */
	       yState = yyFinalToProd [yState - yyFirstReadTermState]; /* read nonterminal reduce */
	    }
	 } else {					/* read */
	    yyStackPtr ++;
	 }
      }
   }

/* access the parse table:   Next : State x Symbol -> Action */

static yyStateRange yyNext
# if defined __STDC__ | defined __cplusplus
   (yyStateRange yyState, yySymbolRange yySymbol)
# else
   (yyState, yySymbol) yyStateRange yyState; yySymbolRange yySymbol;
# endif
   {
      register yyTCombType * yyTCombPtr;

      if (yySymbol <= yyLastTerminal) {
	 for (;;) {
	    yyTCombPtr = yyTBasePtr [yyState] + yySymbol;
	    if (yyTCombPtr->Check != yyState) {
	       if ((yyState = yyDefault [yyState]) == yyNoState) return yyNoState;
	    } else {
	       return yyTCombPtr->Next;
	    }
	 }
      } else {
	return * (yyNBasePtr [yyState] + yySymbol);
      }
   }

static void BeginParser ()
   {
/* line 71 "Parser.lalr" */


   }

void CloseParser ()
   {
/* line 74 "Parser.lalr" */


   }
