/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    terminal.c                                                */
/*                                                              */
/* Description:                                                 */
/*    Implements actions performed when terminals are parsed.   */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

#include <memuser.h>

#include "actions.h"

identifier_list
new_identifier_list 
(char * str,
 tPosition pos)
{
  identifier_list res;
  res = (identifier_list) mem_get_block(sizeof(struct identifier_list_));
  res->string = str;
  res->position = pos;
  res->tail = 0;
  return res;
}

identifier_list
append_identifier_list 
(identifier_list list,
 char * str,
 tPosition pos)
{
  identifier_list cell;
  cell = (identifier_list) mem_get_block(sizeof(struct identifier_list_));
  cell->string = str;
  cell->position = pos;
  cell->tail = list;
  return cell;
}

void
free_identifier_list
(identifier_list list)
{
  while (list) {
    identifier_list tail;
    tail = list->tail;
    mem_free_block(list);
    list = tail;
  }
}

/* ------------------------------------------------------------ */
cvn
identifier_node
(char * name)
{
   cvn declaration, type;

   declaration = 0;
   declaration = get_declaration(name_match, name);
   if(declaration) {
     if(qKind(declaration) == kEnumeratedLiteral ||
        qKind(declaration) == kCharacterLiteral)
       return declaration;
     type = declaration;
   }
   else
     type = 0;
   return mIdentifier(0, name, type);
}

/* ------------------------------------------------------------ */
/* Lu Yuan change these function. I add declaration for literals */

cvn
literal
(int kind,
 char * identifier,
 char character)
{
  cvn tmp;

  if (kind == 0) {
    tmp = mEnumeratedLiteral(0, identifier, 0, 0);
    return tmp;
  } else {
    char *text;                        /*Lu Yuan, Original it is text[4] */
    text = (char *) mem_get_block((SIZE_T) 4 * sizeof(char));
    sprintf(text,"'%c'", character);
    return mCharacterLiteral(0, text, 0, 0);
  }
}

/* ------------------------------------------------------------ */
cvn
character_literal_node
(char val,
 int * nb_errors,
 tPosition pos)
{
  switch (val) {
  case '0' : 
    return bit0_literal;
  case '1' :
    return bit1_literal;
  default :
    {
      unsigned length = strlen("character literal  non accepted") + 2 ;
      char * mess = mem_get_block((SIZE_T) length * sizeof(char)) ;
      sprintf(mess, "character literal %c non accepted", val) ;
      Message(mess, xxError, pos) ;
      mem_free_block(mess) ;
      if (++*nb_errors > max_nb_errors) exit(MAX_NB_ERRORS_EXIT_CODE);
      return 0;
    }
  }
}

