#ifndef __SCANSUPP_H
#define __SCANSUPP_H

#include <ratc.h>
#include <cv.h>


typedef struct {
  short len;
  char * str;
} tBitString;

/* returns value of based integer literal; s: matched string; l: length */
int ScanBasedLit (char *s, int l);

/* returns value of decimal integer literal; s: matched string; l: length */
int ScanDecimalLit (char *s, int l);

/* fills in structure for bit string literal */
int ScanBitStringLit (char *s, int l, tBitString *pbs);

/* same as strdup + strlwr, but for non-null-terminated string */
char *StrnDupLwr (char *src, int len);

/* strdup for string delimited by and possibly containing quotes */
char *QuoteStrnDup (char *src, int len);

#endif
