/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    library.c                                                 */
/*                                                              */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <memuser.h>

#include <Errors.h>
#include <Positions.h>

#include "actions.h"

cvn std_clause;
identifier_list library_clause;

/* ------------------------------------------------------------ */
cvn
open_primary_unit
(char * lib,
 char * name,
 int * nb_errors,
 tPosition position)
{
  cvn entity;

  entity = cv_load_unit(lib, name, "");
  add_declarative_part(entity);
  switch ((qKind(entity))) {
    case kEntityDeclaration :
      add_declarative_part(qPorts(entity)) ;
      break;
    case kPackageDeclaration :
      add_declarative_part(qDeclarations(entity));
      break;
    default :
      Message("error occured while opening design", xxError, position);
      if (++*nb_errors > max_nb_errors) exit(MAX_NB_ERRORS_EXIT_CODE);
      break;
  }
  return entity;
}

/* ------------------------------------------------------------ */

/* open_external_reference(char * lib, char * unit, int *, tPosition)
   Open an external reference by USE clause and store them
   in global variable unit_lib[0]. */

cvn
open_external_reference
(char * lib,
 char * libunit,
 int * nb_errors,
 tPosition position)
{
  identifier_list ptr;
  ptr = library_clause;
  while (ptr && (strcasecmp(lib, ptr->string) != 0)) {
    ptr = ptr->tail;
  }
  if (ptr == 0) {
    char * message;
    message = (char *) mem_get_block((SIZE_T) sizeof(char) *
      (strlen(lib) + strlen("library () not defined") + 1));
    sprintf(message, "library \042%s\042 not defined", lib);
    Message(message, xxError, position);
    mem_free_block(message);
    if (++*nb_errors > max_nb_errors) exit(MAX_NB_ERRORS_EXIT_CODE);
    return 0;
  }
  return open_primary_unit(lib, libunit, nb_errors, position);
}

/* ------------------------------------------------------------ */
/* void
   add_library_logical_name
   (char * name, int * nb_errors, tPosition position)
   Checks that name corresponds to a library logical name, i.e.
   is an environemnt variable, and that the corresponding physical
   name (the value denoted by the environment variable) denotes a
   directory.
*/
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

void
add_library_logical_name
(char * name,
 int * nb_errors,
 tPosition position)
{
  char * directory, * logical;
  struct stat buf;
  if (strcasecmp(name, "work") == 0) {
    logical = getenv("work");
    if (logical == 0) {
      Message("environment variable \042work\042 is not set", 
              xxFatal, position);
      exit(FATAL_EXIT_CODE);
    }
  } else {
    logical = name;
  }
  directory = getenv(logical);
  if (directory == 0) {
    char * message;
    message = (char *) mem_get_block((SIZE_T) sizeof(char) *
      (strlen(logical) + strlen("environment variable () is not set") + 1));
    sprintf(message,
           "environment variable \042%s\042 is not set", 
            logical);
    Message(message, xxError, position);
    mem_free_block((pointer) message);
    if (++*nb_errors > max_nb_errors) exit(MAX_NB_ERRORS_EXIT_CODE);
  }
  stat(directory, & buf);
  if (!S_ISDIR(buf.st_mode)) {
    char * message;
    message = (char *) mem_get_block((SIZE_T) sizeof(char) *
      (strlen(directory) + 
       strlen("physical library () is not a directory") + 
       1));
    sprintf(message,
           "physical library \042%s\042 is not a directory", 
            directory);
    Message(message, xxError, position);
    mem_free_block((pointer) message);
    if (++*nb_errors > max_nb_errors) exit(MAX_NB_ERRORS_EXIT_CODE);
  }
  library_clause = append_identifier_list(library_clause, name, NoPosition);
}

