/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    parse.h                                                   */
/*                                                              */
/* Description:                                                 */
/*    Type and routine declarations used by the parser (see     */
/*    the file "vhdl.parse").                                   */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

#if !defined(_ACTIONSH)
#   define _ACTIONSH

#   include <Errors.h>
#   include <Positions.h>
#   include <cv.h>

#   include "cva.h"

/* ------------------------------------------------------------ */
                                        /* routine declarations */
#   if !defined(ARGS)
#      if defined(__STDC__)
#         define args) args
#      else
#         define args) ()
#      endif
#   endif

/* */
extern void p_Init (void) ;

/* -------------------------------------- type declarations --- */

typedef struct identifier_list_ * identifier_list;
struct identifier_list_ {
  char * string;
  tPosition position;
  identifier_list tail;
};
typedef struct declarative_part_ * tEnvironment ;

typedef enum {kEntity, kArch, kPack, kPackBody} tObject;

/* -------------------------------------- global variables -- */

extern cvn std_clause;
extern identifier_list library_clause;
extern int has_sensitivity_list;

extern int max_nb_errors;
extern const int MAX_NB_ERRORS_EXIT_CODE;
extern const int FATAL_EXIT_CODE;

/* ------------------------------------------ declaration.c --- */


extern void declaration_init (cvn init_decls);
extern void begin_declarative_part (void);
extern void end_declarative_part (void);
extern void free_declaration (void);
extern cvn add_declarative_item (cvn item, int *, tPosition);
extern void set_primary (cvn Name, char * arch_name, int *, tPosition) ;
extern void add_declarative_part (cvn declaration);
extern void remove_declarative_part (void);
extern cvn get_declaration (int (* fn) (cvn, void *), void * criterion) ;
extern void add_declaration (cvn);
extern int name_match (cvn declaration, void * name) ;
extern int symbol_literal (cvn declaration, void * name) ;
extern cvn object_declarations
   (tClass, cvn, cvn, tMode, identifier_list, int *, tPosition) ;
/* -------------------------------------- design-unit.c --- */

extern void unit_begin (int *) ;
extern void unit_end (cvn unit, int *) ;
extern cvn entity_declaration (char * name, cvn ports, int *, tPosition);
extern cvn architecture_body
   (char * name, cvn decls, cvn stms, cvn ent_name, int *, tPosition);
extern cvn package_declaration (char *, cvn, int *, tPosition);
extern cvn package_body (cvn , cvn, int *, tPosition);
extern cvn add_context_clause (cvn unit, cvn clause);
extern void default_context_clause (tKind, char *, int *, tPosition);

/* ------------------------------------------ library.c --- */

extern cvn open_primary_unit (char *, char *, int *, tPosition);
extern cvn open_external_reference (char *, char *, int *, tPosition);
extern void add_library_logical_name (char *, int *, tPosition);

/* ------------------------------------------ expression.c --- */

extern cvn binary_node (tOperator op, cvn left, cvn right, int *, tPosition);
extern cvn unary_node (tOperator op, cvn arg, int *, tPosition);
extern int is_condition (cvn Expression);
extern int is_locally_static (cvn exp);
extern cvn eval_locally_static_exp (cvn exp);
extern cvn put_sign (tOperator, cvn, int *, tPosition);

/* ------------------------------------------- terminal.c --- */

extern identifier_list new_identifier_list (char *, tPosition);
extern identifier_list append_identifier_list 
   (identifier_list, char *, tPosition);
extern void free_identifier_list (identifier_list);
extern cvn identifier_node (char * name) ;
extern cvn character_literal_node (char val, int *, tPosition);
extern cvn literal (int kind, char * identifier, char character);

/* ------------------------------------------------- misc.c --- */

extern void name_is_label (void) ;
extern void name_is_target (void) ;
extern int is_assignment_statement (void) ;
extern cvn append (cvn l1, cvn l2);
extern void production_not_implemented (char * name, int *, tPosition);
extern void check_end_id
   (char * begin_id, char * end_id, int *, tPosition end_pos) ;
extern void set_has_sensitivity_list(void);
extern void reset_has_sensitivity_list(void);

/* ---------------------------------------- statement.c --- */

extern cvn sig_asg_statement (cvn target, cvn source, int *, tPosition) ;
extern cvn conc_sig_asg_statement (cvn target, cvn source, int *, tPosition) ;
extern cvn selected_waveform (cvn source, cvn choices);
extern cvn sel_sig_asg_statement
   (cvn selector, cvn target, cvn alternatives, int *, tPosition);
extern cvn var_asg_statement (cvn target, cvn source, int *, tPosition) ;
extern cvn wait_statement
   (cvn sensitivity_clause, cvn condition_clause, int *, tPosition) ;
extern cvn branch (cvn condition, cvn statements) ;
extern cvn if_statement (cvn branch_if, cvn branch_elsif, 
	 cvn branch_else, int *, tPosition) ;
extern cvn case_alternative (cvn choices, cvn sequential_statements);
extern cvn case_statement (cvn selector, cvn alternatives, int *, tPosition) ;
extern cvn process_statement(cvn sensitivity_list, cvn declarations,
                             cvn statements, int *, tPosition) ;
extern cvn block_statement (cvn declarations, cvn statements, int *, tPosition) ;
extern cvn label_set (cvn stm, char * label, int) ;
extern cvn name_conc_statement (cvn stm, cvn name, int *, tPosition) ;
extern cvn transaction (cvn Value, cvn Delay) ;
extern cvn conditional_waveform (cvn, cvn, cvn, int *, tPosition) ;
extern cvn waveform (cvn Transaction) ;
extern cvn while_statement (cvn, int *, tPosition);
extern cvn for_statement (cvn, cvn, int *, tPosition);
extern cvn loop_statement (cvn, cvn, int *, tPosition);
extern cvn null_statement (int *, tPosition);

/* ------------------------------------------------- type.c --- */

extern cvn integer_type, bit_type, boolean_type;
extern cvn bit0_literal, bit1_literal, false_literal, true_literal;

extern cvn type_init (void);
extern int type_compatible (cvn Type1, cvn Type2) ;
extern cvn subtype_indication (cvn Identifier, cvn range) ;
extern cvn type_declaration 
(char * name, int *, tPosition, cvn definition);
extern cvn subtype_declaration 
(char * name, int *, tPosition, cvn definition);
extern cvn enumeration_type (cvn list);
extern cvn integer_type_d (cvn range);

/* ------------------------------------------------------------ */
extern char * IfDir;
extern unsigned nb_errors;

/* ------------------------------------------------------------ */
#endif _ACTIONSH
/* ------------------------------------------------------------ */
