
signature DEBUG_MODULE =
   sig

      type kind = ILModule.kind
      type con = ILModule.con
      type sg = ILModule.sg
      type term = ILModule.term
      type module = ILModule.module

      exception IndexErrorKind of kind * int option * int list
      exception IndexErrorCon of con * int option * int list
      exception IndexErrorSg of sg * int option * int list
      exception IndexErrorTerm of term * int option * int list
      exception IndexErrorModule of module * int option * int list

      val checkKind : kind -> unit
      val checkCon : con -> unit
      val checkSg : sg -> unit

      val imposeKind : int -> kind -> kind
      val imposeCon : int -> con -> con
      val imposeSg : int -> sg -> sg
      val imposeTerm : int -> term -> term
      val imposeModule : int -> module -> module

   end
