
functor ContextModuleFun (val imposeKind : int -> ILModule.kind -> ILModule.kind
                          val imposeCon : int -> ILModule.con -> ILModule.con
                          val imposeSg : int -> ILModule.sg -> ILModule.sg)
   :> CONTEXT_MODULE
   =
   struct
   
      open ILModule

      type variable = Variable.variable

      structure VariableKey =
         struct
            type t = Variable.variable
            val eq = Variable.eq
            val compare = Variable.compare
         end

      structure Dict = SplayDict (structure Key = VariableKey)

      type context =
         { ksize : int,
           kctx : kind list,
           tctx : (int * con) Dict.dict,
           sctx : (int * sg) Dict.dict }
         (* ksize = |kctx| *)

      val empty = { ksize=0, kctx=[], tctx=Dict.empty, sctx=Dict.empty }

      fun lookupKind ({ kctx, ...}:context) i =
         (SubstModule.liftKind (i+1) (List.nth (kctx, i))
          handle Subscript => raise Misc.TypeError)

      fun lookupType ({ ksize, tctx, ...}:context) v =
         let
            val (n, c) =
               Dict.lookup tctx v
               handle Dict.Absent => raise Misc.TypeError
         in
            SubstModule.liftCon (ksize-n) c
         end

      fun lookupSg ({ ksize, sctx, ...}:context) v =
         let
            val (n, sg) =
               Dict.lookup sctx v
               handle Dict.Absent => raise Misc.TypeError

            val i = ksize - n
         in
            (i-1, SubstModule.liftSg i sg)
         end

      fun extendKind { ksize, kctx, tctx, sctx } k =
         { ksize = ksize+1,
           kctx = imposeKind ksize k :: kctx,
           tctx = tctx,
           sctx = sctx }

      fun extendType { ksize, kctx, tctx, sctx } v c =
         { ksize = ksize,
           kctx = kctx,
           tctx = Dict.insert tctx v (ksize, imposeCon ksize c),
           sctx = sctx }

      fun extendSg { ksize, kctx, tctx, sctx } v sg =
         let
            val sg' = imposeSg ksize sg
         in
            { ksize = ksize+1,
              kctx = FirstModule.fstsg sg :: kctx,
              tctx = tctx,
              sctx = Dict.insert sctx v (ksize, sg') }
         end
   
      fun ksize ({ ksize=n, ...}:context) = n

   end


structure ContextModule =
   ContextModuleFun
   (val imposeKind = DebugModule.imposeKind
    val imposeCon = DebugModule.imposeCon
    val imposeSg = DebugModule.imposeSg)
