
structure CompactModule :> COMPACT_MODULE =
   struct

      open ILModule
      open HashCons

      val kindTable : kind table = table ()
      val conTable : con table = table ()
      val nameTable : name table = table ()
      val sgTable : sg table = table ()

      fun destroy () =
         (
         HashCons.destroyTable kindTable;
         HashCons.destroyTable conTable;
         HashCons.destroyTable nameTable;
         HashCons.destroyTable sgTable;
         HashCons.destroyStringTable ()
         )


      fun Cvar' i = Cvar (i, NONE)

      fun consKind k =
         (case k of
             Ktype =>
                cons0 kindTable 0w1 Ktype
           | Ksing c =>
                cons1
                   kindTable 0w2
                   Ksing (consCon c)
           | Kpi (k1, k2) =>
                cons2
                   kindTable 0w3
                   Kpi (consKind k1, consKind k2)
           | Ksigma (k1, k2) =>
                cons2
                   kindTable 0w4
                   Ksigma (consKind k1, consKind k2)
           | Kunit =>
                cons0 kindTable 0w5 Kunit)

      and consCon c =
         (case c of
             Cvar (i, _) =>
                cons1
                   conTable 0w1
                   Cvar' (consInt i)
           | Clam (k, c) =>
                cons2
                   conTable 0w2
                   Clam (consKind k, consCon c)
           | Capp (c1, c2) =>
                cons2
                   conTable 0w3
                   Capp (consCon c1, consCon c2)
           | Cpair (c1, c2) =>
                cons2
                   conTable 0w4
                   Cpair (consCon c1, consCon c2)
           | Cpi1 c =>
                cons1
                   conTable 0w5
                   Cpi1 (consCon c)
           | Cpi2 c =>
                cons1
                   conTable 0w6
                   Cpi2 (consCon c)
           | Cunit =>
                cons0 conTable 0w7 Cunit
           | Carrow (c1, c2) =>
                cons2
                   conTable 0w8
                   Carrow (consCon c1, consCon c2)
           | Cprod cl =>
                consList
                   conTable 0w11
                   Cprod (map consCon cl)
           | Csum cl =>
                consList
                   conTable 0w12
                   Csum (map consCon cl)
           | Crec c =>
                cons1
                   conTable 0w13
                   Crec (consCon c)
           | Ctag c =>
                cons1
                   conTable 0w14
                   Ctag (consCon c)
           | Cref c =>
                cons1
                   conTable 0w15
                   Cref (consCon c)
           | Cexn =>
                cons0 conTable 0w16 Cexn
           | Cbool =>
                cons0 conTable 0w17 Cbool
           | Cint =>
                cons0 conTable 0w18 Cint
           | Cchar =>
                cons0 conTable 0w19 Cchar
           | Cstring =>
                cons0 conTable 0w20 Cstring)

      fun consName name =
         (case name of
             HIDE =>
                cons0 nameTable 0w1 HIDE
           | VAL str =>
                cons1
                   nameTable 0w2
                   VAL (consString str)
           | CON str =>
                cons1
                   nameTable 0w3
                   CON (consString str)
           | MOD str =>
                cons1
                   nameTable 0w4
                   MOD (consString str)
           | DT str =>
                cons1
                   nameTable 0w5
                   DT (consString str)
           | DCON =>
                cons0 nameTable 0w6 DCON)

      fun consSg sg =
         (case sg of
             Sval c =>
                cons1
                   sgTable 0w1
                   Sval (consCon c)
           | Scon k =>
                cons1
                   sgTable 0w2
                   Scon (consKind k)
           | Ssigma (sg1, sg2) =>
                cons2
                   sgTable 0w3
                   Ssigma (consSg sg1, consSg sg2)
           | Spi (sg1, sg2) =>
                cons2
                   sgTable 0w4
                   Spi (consSg sg1, consSg sg2)
           | Sunit =>
                cons0 sgTable 0w5 Sunit
           | Snamed (name, sg) =>
                cons2
                   sgTable 0w6
                   Snamed (consName name, consSg sg))

      fun compactKind k = #1 (consKind k)
      fun compactCon c = #1 (consCon c)
      fun compactSg sg = #1 (consSg sg)

   end
