
functor ContextHoistFun (val imposeKind : int -> ILHoist.kind -> ILHoist.kind
                           val imposeCon : int -> ILHoist.con -> ILHoist.con)
   :> CONTEXT_HOIST
   =
   struct
   
      open ILHoist

      type variable = Variable.variable

      structure VariableKey =
         struct
            type t = Variable.variable
            val eq = Variable.eq
            val compare = Variable.compare
         end

      structure Dict = SplayDict (structure Key = VariableKey)

      type context =
         { ksize : int, kctx : kind list, tctx : (int * con) Dict.dict }
         (* ksize = |kctx| *)

      val empty = { ksize=0, kctx=[], tctx=Dict.empty }

      fun lookupKind ({ kctx, ...}:context) i =
         (SubstHoist.liftKind (i+1) (List.nth (kctx, i))
          handle Subscript => raise Misc.TypeError)

      fun lookupType ({ ksize, tctx, ...}:context) v =
         let
            val (n, c) =
               Dict.lookup tctx v
               handle Dict.Absent => raise Misc.TypeError
         in
            SubstHoist.liftCon (ksize-n) c
         end

      fun extendKind { ksize, kctx, tctx } k =
         { ksize = ksize+1,
           kctx = imposeKind ksize k :: kctx,
           tctx = tctx }

      fun extendType { ksize, kctx, tctx } v c =
         { ksize = ksize,
           kctx = kctx,
           tctx = Dict.insert tctx v (ksize, imposeCon ksize c) }

      fun ksize ({ ksize=n, ...}:context) = n

   end


structure ContextHoist =
   ContextHoistFun
   ((* Replace these with identity functions for better performance but less error checking. *)
    val imposeKind = DebugHoist.imposeKind
    val imposeCon = DebugHoist.imposeCon)
