
functor MiniFrontEndFun (structure Elaborate : ELABORATE)
   :> 
   FRONT_END 
   =
   struct

      fun elaborate fname =
          let 
             val decls = Parser.parseFile fname

             val sg_m =
                Elaborate.elabDecls ContextModule.empty (ILModule.Cunit, ILModule.Munit, ILModule.Sunit) decls
          in
             SOME sg_m
          end 
          handle Parser.Error => 
                    (
                    print "Parse error.\n";
                    NONE
                    )
               | Misc.TypeError => 
                    (
                    print "Type error.\n";
                    NONE
                    )
                     
   end
