
structure EL =
   struct

      type id = string
      type longid = id list  (* nonempty *)

      datatype tp =
         Cident of longid
       | Carrow of tp * tp
       | Cprod of tp list   (* unit = Cprod [] *)
       | Cbool
       | Cint
       | Cstring
       | Cchar

      datatype spec =
         Sval of id * tp
       | Stype of id
       | Stypeeq of id * tp
       | Smodule of id * sg
       | Sdata of id * (id * tp) list

      withtype sg = spec list

      datatype pattern =
         Pident of id
       | Papp of longid * pattern
       | Ptuple of pattern list
       | Pint of int

      datatype opacity = Transparent | Opaque

      datatype term =
         Tvar of longid
       | Tlam of id * tp * term
       | Tapp of term * term
       | Ttuple of term list
       | Tcase of term * match
       | Tlet of decl list * term
       | Tbool of bool
       | Tint of int
       | Tchar of char
       | Tstring of string
       | Tprim of ELPrim.prim

      and decl =
         Dval of pattern * term
       | Dfun of id * id * tp * tp * term
       | Dtype of id * tp
       | Dmodule of id * module
       | Ddata of id * (id * tp) list
       | Dopen of longid
       | Dlocal of decl list * decl list

      and module =
         Mident of longid
       | Mstruct of decl list
       | Mseal of module * opacity * sg

      withtype match = (pattern * term) list  (* nonempty *)

   end
