
structure Ascribe :> ASCRIBE =
   struct

      open ILModule
      open SubstModule
      open ContextModule
      open EquivModule

      exception TypeError = Misc.TypeError

      (* coerceField name G C M S1 S2

         Suppose G |-p M : S1
                 G |- Fst(M) >> C
                 M is valuable  (see resolve.sig)
         and     G |- S2 : sig
                 S2 contains only ascribeable names
         then    returns (S, M')
                 where
                 G |- M' : S  (not necessarily determinate)
                 G |- S <: S2
                 or
                 raises Misc.TypeError
      *)
      fun coerceField name ctx c m sg1 sg2 =
         (case name of
             VAL _ =>
                (case (sg1, sg2) of
                    (Sval c1, Sval c2) =>
                       (
                       equiv ctx c1 c2 Ktype;
                       (sg2, m)
                       )
                  | (Snamed (DCON, Sval c1), Sval c2) =>
                       (case whnf ctx c1 of
                           Cprod [c1', _] =>
                              (
                              equiv ctx c1' c2 Ktype;
                              (sg2, Mval (Tproj (Tsnd (Mout m), 0)))
                              )
                         | _ =>
                              raise TypeError)
                  | (Snamed (DCON, Sval c1), Snamed (DCON, Sval c2)) =>
                       (
                       equiv ctx c1 c2 Ktype;
                       (sg2, m)
                       )
                  | _ =>
                       raise TypeError)
           | CON _ =>
                (case (sg1, sg2) of
                    (Scon k1, Scon k2) =>
                       (
                       EquivModule.subkind ctx k1 k2;
                       (sg1, m)
                       )
                  | _ =>
                       raise TypeError)
           | MOD _ =>
                coerce ctx c m sg1 sg2
           | DT _ =>
                (
                subsg ctx sg1 sg2;
                (sg1, m)
                )
           | _ =>
                (* Not an ascribeable name. *)
                raise (Fail "invariant"))

      (* coerce G C M S1 S2

         Suppose G |-p M : S1
                 G |- Fst(M) >> C
                 M is valuable
         and     G |- S2 : sig
                 S2 contains only ascribeable names
         then    returns (S, M')
                 where
                 G |- M' : S  (not necessarily determinate)
                 G |- S <: S2
                 or
                 raises Misc.TypeError
      *)
      and coerce ctx c m sg1 sg2 =
         (case sg2 of
             Snamed (name, sg2') =>
                let 
                   val (c', m', sg1') = 
                      Resolve.resolve1 (c, m, sg1) name
                      handle Resolve.Resolve => raise TypeError

                   val (sgCoerced, mCoerced) =
                      coerceField name ctx c' m' sg1' sg2'
                in
                   (Snamed (name, sgCoerced), Min (name, mCoerced))
                end
           | Ssigma (sg2a, sg2b) =>
                let 
                   val (sgA, mA) = coerce ctx c m sg1 sg2a

                   val v = Variable.newvar ()
                   val ctx' = extendSg ctx v sgA

                   val (sgB, mB) =
                      coerce ctx' (liftCon 1 c) (liftModule 1 m) (liftSg 1 sg1) sg2b
                in
                   (Ssigma (sgA, sgB), Mdpair (v, mA, mB))
                end
           | Sunit =>
                (Sunit, Munit)
           | _ =>
                raise TypeError)

      fun ascribe ctx m sg sgAscribe opacity =
         let 
            val v = Variable.newvar ()
            val ctx' = extendSg ctx v (Snamed (HIDE, sg))
            
            val zero = Cvar (0, SOME (ksize ctx'))

            val sgAscribe' = liftSg 1 sgAscribe

            val (sg', m') =
               coerce ctx' zero (Mout (Mvar v)) (selfifySg zero (liftSg 1 sg)) sgAscribe'

            val sg'' =
               (case opacity of
                   EL.Transparent => sg'
                 | EL.Opaque => sgAscribe')

            val fullsg =
               CompactModule.compactSg (Ssigma (Snamed (HIDE, sg), sg''))
         in
            (fullsg,
             Mseal (Mdpair (v, Min (HIDE, m), m'), fullsg))
         end

   end
