
structure FreevarsCps :> FREEVARS_CPS =
   struct

      open ILCps
      open VariableSet

      fun freevarsExp e =
         (case e of
             Eapp (v1, v2) =>
                union (freevarsValue v1) (freevarsValue v2)
           | Eunpack (x, v, e) =>
                union (freevarsValue v) (remove (freevarsExp e) x)
           | Eproj (x, v, _, e) =>
                union (freevarsValue v) (remove (freevarsExp e) x)
           | Ecase (v, arms) =>
                List.foldl
                   (fn ((x, e), set) =>
                       union (remove (freevarsExp e) x) set)
                   (freevarsValue v)
                   arms
           | Eiftag (v1, v2, x, e1, e2) =>
                union 
                   (freevarsValue v1)
                   (union 
                       (freevarsValue v2)
                       (union
                           (remove (freevarsExp e1) x)
                           (freevarsExp e2)))
           | Enewtag (x, _, e) =>
                remove (freevarsExp e) x
           | Eref (x, v, e) =>
                union (freevarsValue v) (remove (freevarsExp e) x)
           | Ederef (x, v, e) =>
                union (freevarsValue v) (remove (freevarsExp e) x)
           | Eassign (v1, v2, e) =>
                union
                   (freevarsValue v1)
                   (union
                       (freevarsValue v2)
                       (freevarsExp e))
           | Eif (v, e1, e2) =>
                union
                   (freevarsValue v)
                   (union
                       (freevarsExp e1)
                       (freevarsExp e2))
           | Elet (x, v, e) =>
                union (freevarsValue v) (remove (freevarsExp e) x)
           | Eprim (x, _, vl, e) =>
                List.foldl
                   (fn (v, set) =>
                       union (freevarsValue v) set)
                   (remove (freevarsExp e) x)
                   vl
           | Ehalt => empty)

      and freevarsValue v =
         (case v of
             Vvar x =>
                singleton x
           | Vlam (x, _, e) =>
                remove (freevarsExp e) x
           | Vpack (_, v, _) =>
                freevarsValue v
           | Vtuple vl =>
                List.foldl
                   (fn (v, set) =>
                       union (freevarsValue v) set)
                   empty
                   vl
           | Vinj (v, _, _) =>
                freevarsValue v
           | Vroll (v, _) =>
                freevarsValue v
           | Vunroll v =>
                freevarsValue v
           | Vtag (v1, v2) =>
                union (freevarsValue v1) (freevarsValue v2)
           | Vbool _ => empty
           | Vint _ => empty
           | Vchar _ => empty
           | Vstring _ => empty)

   end
