
structure ResultModule =
   struct

      datatype result =
         Rfn of result -> result
       | Rtuple of result list
       | Rinj of result * int
       | Rroll of result
       | Rtag of unit ref
       | Rexn of unit ref * result
       | Rref of result ref
       | Rbool of bool
       | Rint of int
       | Rchar of char
       | Rstring of string

      and mresult =
         MRval of result
       | MRcon
       | MRunit
       | MRpair of mresult * mresult
       | MRfn of (mresult -> mresult)
       | MRin of mresult

      exception Wrong
      exception RaiseExn of result

   end
