
structure ILModule =
   struct

      datatype kind =
         Ktype
       | Ksing of con
       | Kpi of kind * kind     (* binds *)
       | Ksigma of kind * kind  (* binds *)
       | Kunit

      and con =
         Cvar of int * int option
       | Clam of kind * con     (* binds *)
       | Capp of con * con
       | Cpair of con * con
       | Cpi1 of con
       | Cpi2 of con
       | Cunit

       | Carrow of con * con
       | Cprod of con list
       | Csum of con list
       | Crec of con            (* binds *)
       | Ctag of con
       | Cref of con
       | Cexn
       | Cbool
       | Cint
       | Cchar
       | Cstring

      datatype name =
         HIDE
       | VAL of string
       | CON of string
       | MOD of string
       | DT of string
       | DCON

      datatype sg =
         Sval of con
       | Scon of kind
       | Ssigma of sg * sg      (* binds *)
       | Spi of sg * sg         (* binds *)
       | Sunit
       | Snamed of name * sg

      type variable = Variable.variable

      datatype term =
         Tvar of variable

       | Tlam of variable * con * term
       | Tapp of term * term

       | Ttuple of term list
       | Tproj of term * int

       | Tinj of term * int * con
       | Tcase of term * (variable * term) list

       | Troll of term * con
       | Tunroll of term

       | Ttag of term * term
       | Tiftag of term * term * variable * term * term
       | Tnewtag of con

       | Traise of term * con
       | Thandle of term * variable * term

       | Tref of term
       | Tderef of term
       | Tassign of term * term

       | Tbool of bool
       | Tif of term * term * term

       | Tint of int
       | Tchar of char
       | Tstring of string

       | Tlet of variable * term * term
       | Tletm of variable * module * term * con  (* binds *)

       | Tprim of Prim.prim * term list

       | Tsnd of module

      and module =
         Mvar of variable

       | Mval of term
       | Mcon of con
       | Munit

       | Mpair of module * module
       | Mdpair of variable * module * module     (* binds *)
       | Mpi1 of module
       | Mpi2 of module

       | Mlam of variable * sg * module           (* binds *)
       | Mapp of module * module

       | Min of name * module
       | Mout of module

       | Mlet of variable * module * module * sg  (* binds *)
       | Mletd of variable * module * module      (* binds *)
       | Mlete of variable * term * module

       | Mseal of module * sg

   end
