
functor PrimTypeFun (structure Param : PRIM_TYPE_PARAM)
   :>
   PRIM_TYPE
   where type con = Param.con
   =
   struct

      open Prim
      open Param

      fun primtype p =
          (case p of
              Neg =>
                 ([Cint], Cint)
            | Plus =>
                 ([Cint, Cint], Cint)
            | Minus =>
                 ([Cint, Cint], Cint)
            | Times =>
                 ([Cint, Cint], Cint)
            | Div =>
                 ([Cint, Cint], Cint)
            | Mod =>
                 ([Cint, Cint], Cint)
            | EqInt =>
                 ([Cint, Cint], Cbool)
            | LtInt =>
                 ([Cint, Cint], Cbool)
            | LeqInt =>
                 ([Cint, Cint], Cbool)
            | IntToString =>
                 ([Cint], Cstring)
            | EqChar =>
                 ([Cchar, Cchar], Cbool)
            | Concat =>
                 ([Cstring, Cstring], Cstring)
            | EqString =>
                 ([Cstring, Cstring], Cbool)
            | LtString =>
                 ([Cstring, Cstring], Cbool)
            | Print =>
                 ([Cstring], Cunittype))

   end
