
signature LIST =
   sig
      datatype 'a list = N | C of 'a * 'a list
   end

signature FOO =
   sig
      type 'a list
      val map : ('a -> 'b) -> 'a list -> 'b list
   end

functor FooFun (structure List : LIST)
   :> FOO where type 'a list = 'a List.list
   =
   struct
      open List

      fun map f l =
          (case l of
              N => N
            | C (h, t) =>
                 C (f h, map f t))
   end

structure List :> LIST =
   struct
      datatype 'a list = N | C of 'a * 'a list
   end

structure Foo = FooFun (structure List = List)

open List

val l = Foo.map (fn x => x + 1) (C (3, C (1, N)))

fun sum l =
    (case l of
        N => 0
      | C (h, t) =>
           h + sum t)

val () = print (Int.toString (sum l))
