
signature DEBUG_HOIST =
   sig

      type kind = ILHoist.kind
      type con = ILHoist.con
      type exp = ILHoist.exp
      type value = ILHoist.value
      type function = ILHoist.function
      type program = ILHoist.program

      exception IndexErrorKind of kind * int option * int list
      exception IndexErrorCon of con * int option * int list
      exception IndexErrorExp of exp * int option * int list
      exception IndexErrorValue of value * int option * int list
      exception IndexErrorFunction of function * int option * int list
      exception IndexErrorProgram of program * int list

      val checkKind : kind -> unit
      val checkCon : con -> unit

      val imposeKind : int -> kind -> kind
      val imposeCon : int -> con -> con
      val imposeExp : int -> exp -> exp
      val imposeValue : int -> value -> value
      val imposeFunction : int -> function -> function
      val imposeProgram : program -> program

   end
