
structure SubstClosure :> SUBST_CLOSURE =
   struct

      open ILClosure
      structure V = Variable
      structure D = VariableDict

      (* substXMain m s n l exp 
       
         if    |s| = n
         then  return exp[0 .. m-1 . s0[^m] .. sn-1[^m] . ^l+m]
      *)

      fun substKindMain m s n l k =
         (case k of
             Ktype => k
           | Ksing c =>
                Ksing (substConMain m s n l c)
           | Kpi (k1, k2) =>
                Kpi (substKindMain m s n l k1, substKindMain (m+1) s n l k2)
           | Ksigma (k1, k2) =>
                Ksigma (substKindMain m s n l k1, substKindMain (m+1) s n l k2)
           | Kunit => k)

      and substConMain m s n l c =
         (case c of
             Cvar (i, NONE) =>
                if i < m then
                   c
                else if i < m+n then
                   substConMain 0 [] 0 m (List.nth (s, i-m))
                else
                   Cvar (i-n+l, NONE)
           | Cvar (i, SOME j) =>
                if i < m then
                   Cvar (i, SOME (j-n+l))
                else if i < m+n then
                   substConMain 0 [] 0 m (List.nth (s, i-m))
                else
                   Cvar (i-n+l, SOME (j-n+l))
           | Clam (k, c) =>
                Clam (substKindMain m s n l k, substConMain (m+1) s n l c)
           | Capp (c1, c2) =>
                Capp (substConMain m s n l c1, substConMain m s n l c2)
           | Cpair (c1, c2) =>
                Cpair (substConMain m s n l c1, substConMain m s n l c2)
           | Cpi1 c =>
                Cpi1 (substConMain m s n l c)
           | Cpi2 c =>
                Cpi2 (substConMain m s n l c)
           | Cunit => c
           | Cnot c =>
                Cnot (substConMain m s n l c)
           | Cexists (k, c) =>
                Cexists (substKindMain m s n l k, substConMain (m+1) s n l c)
           | Cprod cl =>
                Cprod (map (substConMain m s n l) cl)
           | Csum cl =>
                Csum (map (substConMain m s n l) cl)
           | Crec c =>
                Crec (substConMain (m+1) s n l c)
           | Ctag c =>
                Ctag (substConMain m s n l c)
           | Cref c =>
                Cref (substConMain m s n l c)
           | Cexn => c
           | Cbool => c
           | Cint => c
           | Cchar => c
           | Cstring => c)

      fun substExpMain m s n l e =
         (case e of
             Eapp (v1, v2) =>
                Eapp (substValueMain m s n l v1, substValueMain m s n l v2)
           | Eunpack (x, v, e) =>
                Eunpack (x, substValueMain m s n l v, substExpMain (m+1) s n l e)
           | Eproj (x, v, i, e) =>
                Eproj (x, substValueMain m s n l v, i, substExpMain m s n l e)
           | Ecase (v, arms) =>
                Ecase (substValueMain m s n l v, map (fn (xi, ei) => (xi, substExpMain m s n l ei)) arms)
           | Eiftag (v1, v2, x, e1, e2) =>
                Eiftag (substValueMain m s n l v1, substValueMain m s n l v2, x, substExpMain m s n l e1, substExpMain m s n l e2)
           | Enewtag (x, t, e) =>
                Enewtag (x, substConMain m s n l t, substExpMain m s n l e)
           | Eref (x, v, e) =>
                Eref (x, substValueMain m s n l v, substExpMain m s n l e)
           | Ederef (x, v, e) =>
                Ederef (x, substValueMain m s n l v, substExpMain m s n l e)
           | Eassign (v1, v2, e) =>
                Eassign (substValueMain m s n l v1, substValueMain m s n l v2, substExpMain m s n l e)
           | Eif (v, e1, e2) =>
                Eif (substValueMain m s n l v, substExpMain m s n l e1, substExpMain m s n l e2)
           | Elet (x, v, e) =>
                Elet (x, substValueMain m s n l v, substExpMain m s n l e)
           | Eprim (x, prim, vl, e) =>
                Eprim (x, prim, map (substValueMain m s n l) vl, substExpMain m s n l e)
           | Ehalt =>
                e)

      and substValueMain m s n l v =
         (case v of
             Vvar _ =>
                v
           | Vlam (x, c, e) =>
                Vlam (x, substConMain m s n l c, substExpMain m s n l e)
           | Vpack (c1, v', c2) =>
                Vpack (substConMain m s n l c1, substValueMain m s n l v', substConMain m s n l c2)
           | Vtuple vl =>
                Vtuple (map (substValueMain m s n l) vl)
           | Vinj (v', i, c) =>
                Vinj (substValueMain m s n l v', i, substConMain m s n l c)
           | Vroll (v', c) =>
                Vroll (substValueMain m s n l v', substConMain m s n l c)
           | Vunroll v' =>
                Vunroll (substValueMain m s n l v')
           | Vtag (v1, v2) =>
                Vtag (substValueMain m s n l v1, substValueMain m s n l v2)
           | Vbool _ => v
           | Vint _ => v
           | Vchar _ => v
           | Vstring _ => v)

      fun dsubstExpMain m s n l d e =
         (case e of
             Eapp (v1, v2) =>
                Eapp (dsubstValueMain m s n l d v1, dsubstValueMain m s n l d v2)
           | Eunpack (x, v, e) =>
                let
                   val x' = V.newvar ()
                in
                   Eunpack (x', dsubstValueMain m s n l d v, dsubstExpMain (m+1) s n l (D.insert d x (Vvar x')) e)
                end
           | Eproj (x, v, i, e) =>
                let
                   val x' = V.newvar ()
                in
                   Eproj (x', dsubstValueMain m s n l d v, i, dsubstExpMain m s n l (D.insert d x (Vvar x')) e)
                end
           | Ecase (v, arms) =>
                Ecase (dsubstValueMain m s n l d v,
                       map 
                          (fn (xi, ei) =>
                              let
                                 val xi' = V.newvar ()
                              in
                                 (xi', dsubstExpMain m s n l (D.insert d xi (Vvar xi')) ei)
                              end)
                          arms)
           | Eiftag (v1, v2, x, e1, e2) =>
                let
                   val x' = V.newvar ()
                in
                   Eiftag (dsubstValueMain m s n l d v1, 
                           dsubstValueMain m s n l d v2, 
                           x', dsubstExpMain m s n l (D.insert d x (Vvar x')) e1, 
                           dsubstExpMain m s n l d e2)
                end
           | Enewtag (x, t, e) =>
                let
                   val x' = V.newvar ()
                in
                   Enewtag (x', substConMain m s n l t, dsubstExpMain m s n l (D.insert d x (Vvar x')) e)
                end
           | Eref (x, v, e) =>
                let
                   val x' = V.newvar ()
                in
                   Eref (x', dsubstValueMain m s n l d v, dsubstExpMain m s n l (D.insert d x (Vvar x')) e)
                end
           | Ederef (x, v, e) =>
                let
                   val x' = V.newvar ()
                in
                   Ederef (x', dsubstValueMain m s n l d v, dsubstExpMain m s n l (D.insert d x (Vvar x')) e)
                end
           | Eassign (v1, v2, e) =>
                Eassign (dsubstValueMain m s n l d v1, dsubstValueMain m s n l d v2, dsubstExpMain m s n l d e)
           | Eif (v, e1, e2) =>
                Eif (dsubstValueMain m s n l d v, dsubstExpMain m s n l d e1, dsubstExpMain m s n l d e2)
           | Elet (x, v, e) =>
                let
                   val x' = V.newvar ()
                in
                   Elet (x', dsubstValueMain m s n l d v, dsubstExpMain m s n l (D.insert d x (Vvar x')) e)
                end
           | Eprim (x, prim, vl, e) =>
                let
                   val x' = V.newvar ()
                in
                   Eprim (x', prim, map (dsubstValueMain m s n l d) vl, dsubstExpMain m s n l (D.insert d x (Vvar x')) e)
                end
           | Ehalt =>
                e)

      and dsubstValueMain m s n l d v =
         (case v of
             Vvar x =>
                (case VariableDict.find d x of
                    NONE => v
                  | SOME v' =>
                       if m = 0 then
                          v'
                       else
                          substValueMain 0 [] 0 m v')
           | Vlam (x, c, e) =>
                let
                   val x' = V.newvar ()
                in
                   Vlam (x', substConMain m s n l c, dsubstExpMain m s n l (D.insert d x (Vvar x')) e)
                end
           | Vpack (c1, v', c2) =>
                Vpack (substConMain m s n l c1, dsubstValueMain m s n l d v', substConMain m s n l c2)
           | Vtuple vl =>
                Vtuple (map (dsubstValueMain m s n l d) vl)
           | Vinj (v', i, c) =>
                Vinj (dsubstValueMain m s n l d v', i, substConMain m s n l c)
           | Vroll (v', c) =>
                Vroll (dsubstValueMain m s n l d v', substConMain m s n l c)
           | Vunroll v' =>
                Vunroll (dsubstValueMain m s n l d v')
           | Vtag (v1, v2) =>
                Vtag (dsubstValueMain m s n l d v1, dsubstValueMain m s n l d v2)
           | Vbool _ => v
           | Vint _ => v
           | Vchar _ => v
           | Vstring _ => v)

      fun substKindGen m s l exp =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               exp
            else
               substKindMain m s n l exp
         end

      fun substConGen m s l exp =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               exp
            else
               substConMain m s n l exp
         end

      fun substExpGen m s l exp =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               exp
            else
               substExpMain m s n l exp
         end

      fun substValueGen m s l exp =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               exp
            else
               substValueMain m s n l exp
         end

      fun dsubstExpGen m s l d exp =
         if D.isEmpty d then
            let
               val n = length s
            in
               if n = 0 andalso l = 0 then
                  exp
               else
                  substExpMain m s n l exp
            end
         else
            dsubstExpMain m s (length s) l d exp

      fun dsubstValueGen m s l d exp =
         if D.isEmpty d then
            let
               val n = length s
            in
               if n = 0 andalso l = 0 then
                  exp
               else
                  substValueMain m s n l exp
            end
         else
            dsubstValueMain m s (length s) l d exp

      fun liftKind l exp =
         if l = 0 then
            exp
         else
            substKindMain 0 [] 0 l exp

      fun liftCon l exp =
         if l = 0 then
            exp
         else
            substConMain 0 [] 0 l exp

      fun liftExp l exp =
         if l = 0 then
            exp
         else
            substExpMain 0 [] 0 l exp

      fun liftValue l exp =
         if l = 0 then
            exp
         else
            substValueMain 0 [] 0 l exp

      fun substKind s exp = substKindMain 0 [s] 1 0 exp
      fun substCon s exp = substConMain 0 [s] 1 0 exp
      fun substExp s exp = substExpMain 0 [s] 1 0 exp
      fun substValue s exp = substValueMain 0 [s] 1 0 exp

   end
