
signature DEBUG_CLOSURE =
   sig

      type kind = ILClosure.kind
      type con = ILClosure.con
      type exp = ILClosure.exp
      type value = ILClosure.value

      exception IndexErrorKind of kind * int option * int list
      exception IndexErrorCon of con * int option * int list
      exception IndexErrorExp of exp * int option * int list
      exception IndexErrorValue of value * int option * int list

      val checkKind : kind -> unit
      val checkCon : con -> unit

      val imposeKind : int -> kind -> kind
      val imposeCon : int -> con -> con
      val imposeExp : int -> exp -> exp
      val imposeValue : int -> value -> value

   end
