
structure Depth :> DEPTH =
   struct

      datatype depth =
         AtLeast of int  (* >= 0 *)
       | Exactly of int  (* >= 0 *)

      val bottom = AtLeast 0

      fun inc d =
         (case d of
             AtLeast n =>
                AtLeast (n+1)
           | Exactly n =>
                Exactly (n+1))

      fun dec exn d =
         (case d of
             AtLeast 0 => d
           | AtLeast n =>
                AtLeast (n-1)
           | Exactly 0 =>
                raise exn
           | Exactly n =>
                Exactly (n-1))

      fun join exn d1_d2 =
         (case d1_d2 of
             (d1 as AtLeast n1, d2 as AtLeast n2) =>
                if n1 >= n2 then
                   d1
                else
                   d2
           | (AtLeast n1, d2 as Exactly n2) =>
                if n2 >= n1 then
                   d2
                else
                   raise exn
           | (d1 as Exactly n1, AtLeast n2) =>
                if n1 >= n2 then
                   d1
                else
                   raise exn
           | (d1 as Exactly n1, Exactly n2) =>
                if n1 = n2 then
                   d1
                else
                   raise exn)

   end

