
structure Subst :> SUBST
   =
   struct

      open Syntax

      (* |s| = n *)
      fun substKindMain m s n l k =
         (case k of
             Ktype => k
           | Ksing c =>
                Ksing (substConMain m s n l c)
           | Kpi (k1, k2) =>
                Kpi (substKindMain m s n l k1, substKindMain (m+1) s n l k2)
           | Ksigma (k1, k2) =>
                Ksigma (substKindMain m s n l k1, substKindMain (m+1) s n l k2)
           | Kunit => k)

      (* |s| = n *)
      and substConMain m s n l c =
         (case c of
             Cvar i =>
                if i < m then
                   c
                else if i < m+n then
                   substConMain 0 [] 0 m (List.nth (s, i-m))
                else
                   Cvar (i-n+l)
           | Clam (k, c1) =>
                Clam (substKindMain m s n l k, substConMain (m+1) s n l c1)
           | Capp (c1, c2) =>
                Capp (substConMain m s n l c1, substConMain m s n l c2)
           | Cpair (c1, c2) =>
                Cpair (substConMain m s n l c1, substConMain m s n l c2)
           | Cpi1 c =>
                Cpi1 (substConMain m s n l c)
           | Cpi2 c =>
                Cpi2 (substConMain m s n l c)
           | Cunit => c
           | Carrow (c1, c2) =>
                Carrow (substConMain m s n l c1, substConMain m s n l c2)
           | Cforall (k, c1) =>
                Cforall (substKindMain m s n l k, substConMain (m+1) s n l c1))

      fun substKindGen m s l k =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               k
            else
               substKindMain m s n l k
         end

      fun substConGen m s l c =
         let
            val n = length s
         in
            if n = 0 andalso l = 0 then
               c
            else
               substConMain m s n l c
         end

      fun liftKind l k = substKindMain 0 [] 0 l k
      fun liftCon l c = substConMain 0 [] 0 l c

      fun substKind s k = substKindMain 0 [s] 1 0 k
      fun substCon s c = substConMain 0 [s] 1 0 c

   end
