
signature EQUIV =
   sig

      type kind = Syntax.kind
      type con = Syntax.con

      type context = kind list

      exception TypeError
 

      (* naturalKind G c

         Suppose  G |- c : k
         Then     return k'
                  where
                  G |- c ^ k'
      *)
      val naturalKind : context -> con -> kind


      (* whnf G c 

         Suppose  G |- c : k
         Then     return c'
                  where
                  c' is the weak-head normal form of c
      *)
      val whnf : context -> con -> con


      (* equiv G c c' k

         Suppose  G |- c : k
                  G |- c' : k
         Then     if    G |- c <=> c' : k
                  then  return ()
                  else  raise TypeError
      *)
      val equiv : context -> con -> con -> kind -> unit


      (* equivStr G c c'

         Suppose  G |- c : k
                  G |- c' : k
                  c, c' are weak-head-normal forms
         Then     if    G |- c <-> c' : k
                  then  return k
                  else  raise TypeError
      *)
      val equivStr : context -> con -> con -> kind

      
      (* samekind G k k'

         Suppose  G |- k : kind
                  G |- k' : kind
         Then     if    G |- k <=> k' : kind
                  then  return ()
                  else  raise TypeError
      *)
      val samekind : context -> kind -> kind -> unit


      (* subkind G k k'

         Suppose  G |- k : kind
                  G |- k' : kind
         Then     if    G |- k <| k' : kind
                  then  return ()
                  else  raise TypeError
      *)
      val subkind : context -> kind -> kind -> unit

   end
