
signature UTIL =
   sig

      datatype ('a, 'b) sum = INL of 'a | INR of 'b

      type void
      val abort : void -> 'a

   end


structure Util :> UTIL =
   struct

      datatype ('a, 'b) sum = INL of 'a | INR of 'b

      datatype void = VOID of void

      fun abort (_ : void) = raise (Fail "this is impossible")

   end


open Util


signature PROOFS_AS_PROGRAMS =
   sig

      val curry : (('a * 'b -> 'c) -> 'a -> 'b -> 'c) option
      val abba : ((('a -> 'b) -> 'b) -> 'a) option
      val contrapositive : (('a -> 'b) -> (('b -> void) -> ('a -> void))) option
      val exclusion : (('a, 'b) sum * ('a -> void) -> 'b) option

   end
