// serial interface routines header

#ifndef _SERCOMM_H_
#define _SERCOMM_H_

#include "877reg.h"

// SPBRG_VAL based on BRGH=0
// SPBRG_VAL == ( Fosc / 64*baudrate ) - 1
// 2400:  192
// 9600:  31
// 19200: 15

// SPBRG_VAL for BRGH=1
// SPBRG_VAL == ( Fosc / 16*baudrate ) - 1
#define SER_9600 129
#define SER_19200 64
#define SER_38400 31
#define SER_57600 21
#define SER_115200 10

char ser_tmp;

void ser_init(char spbrg_val) {
	
	SSPCON = 0;
	PIR1 = 0;

	RCIF = 0;
	TXIF = 0;
	RCIE = 0;
	TXIE = 0;

	TRISC = TRISC | 0xC0; // setup TRISC for USART use

	SPBRG = spbrg_val;

    //TXSTA = 00100000b; // txen, the rest all off
    TXSTA = 0b00100100; // txen, brgh
	// check that TXIF == 1

	RCSTA = 0b10010000; // spen and cren, the rest all off

	ser_tmp = RCREG; // flush the rx buffer
	ser_tmp = RCREG;
	ser_tmp = RCREG;

	//TXREG = 0; // tx dummy char

}

void ser_tx(char c) {

	//wait for txif to go hi
	while (!TXIF);
	
	//disable_interrupt(GIE); //?
	TXREG = c;
	//enable_interrupt(GIE);  //?
}

char ser_rx(void) {
	while (1) {
		if (OERR) {
			// overflow error
			// disable_interrupt(GIE)?
			CREN = 0;
			ser_tmp = RCREG; // flush the rx buffer
			ser_tmp = RCREG;
			ser_tmp = RCREG;
			CREN = 1;
			// enable_interrupt(GIE)?
		}
		else if (FERR) {
			// framing error
			// disable_interrupt(GIE)?
			ser_tmp = RCREG;
			// enable_interrupt(GIE)?
			//set_bit(PORTD,1);
		}
		else if (RCIF) {
			// RCIF!
			// disable_interrupt(GIE)?
			ser_tmp = RCREG;
			// enable_interrupt(GIE)?
			
			return ser_tmp;
		}
	}
}

/*
void putstring(char* text) {
    char i = 0;
    while( text[i] != 0 )
        ser_tx( text[i++] ); 
}
*/

/*
void puthex(char data) {
	ser_tmp = data >> 4;
    //Send high nibble
    if (ser_tmp > 9)
        ser_tx( 'A' - 10 + ser_tmp );
    else
        ser_tx( '0' + ser_tmp );
	ser_tmp = data & 0x0F;
    //Send low nibble
    if( ser_tmp > 9 )
        ser_tx( 'A' - 10 + ser_tmp );
    else
        ser_tx( '0' + ser_tmp );
}

void putdec(char data) {
    ser_tx( '0' + data/100 );
    ser_tx( '0' + (data%100)/10 );
    ser_tx( '0' + data%10 );
    
/*    char i;
    
    if (data < 200) {
    	data -= 200;
    	ser_tx('2');
    }
    if (data < 100) {
    	data -= 100;
    	ser_tx('1');
    }
    for (i='0'; data > 9; i++) {
    	data -= 10;
    	i++;
    }
    if (i > '0') ser_tx(i);
    ser_tx(data + '0');*
}

char getdec(void) {
	char i=0;
	
	ser_tmp = 0;
	
	while ((ser_tmp != '\n')&&(ser_tmp != '\r')) {
		ser_tmp = ser_rx();
	
		if ((ser_tmp > 47)&&(ser_tmp < 58)) {
			// it's a digit!
			i = i * 10;
			ser_tmp = ser_tmp - '0';
			i = i + ser_tmp;
		}
	} 
	
	return i;
}
*/
#endif