///////////////////////////////////////////////////////
//
// FileName: lilbot1.c
// Author: kwanjee and illah
// This is a lilbot demo program for the 3D bot (with
// moving spoon). It turns and pitches to face the reddest
// object, and does *not* creep. Also, for robustness, auto
// white balance is off. Auto gain is permanently on.
//
// Serial user interface (implementing v0.2)
//
////////////////////////////////////////////////////////

#include <16f877.h>
#include "877reg.h"
#include "sercomm.h"
#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"

#define LW 7 // left wheel servo num
#define RW 6 // right wheel servo num
#define SW 5 // spoon wheel servo num (pitch control) 
// on the spoon servo, 190 is more or less straight ahead
// 230 is pointed way down. 100 is pointed way up pitch to sky
//remember, larger numbers lead to ccw rotation wrt servo center

#define CENTERX 40 // the x axis center of the camera
#define CENTERY 70 // the y axis center of the camera i think
#define LWCTR 159 // the center (zero velocity) position of l servo
#define RWCTR 159
#define FAST 7 // the speed differential to use to spin fast
#define SLOW 2 // the speed for slow servo wheel spinning
#define ROTDB 5 // the deadband halfwidth for rotation
#define ROTSF 20 // the halfwidth threshold for slow-fast transition
#define SPOONMIN 60 // minimum position for spoon
#define SPOONMAX 220 // maximum position for spoon


char buf[30];
char bp;
unsigned char targetx; // xpos of target
unsigned char targety; // height of target
unsigned char lastspoonpos; // last position of spoon servo //

// camera parameters
char xpos;
char pxpos;
char size;
char conf;
signed char dx;
signed char dy;

// color parameters
char rmin, rmax, gmin, gmax, bmin, bmax;

char putbuf(char p, char data) {
	// does sprintf of data into buf[p]
	
	char i;
	
	if (data >= 200)	{
		data -=	200;
		buf[p++] = '2';
	}
	if (data >= 100)	{
		data -=	100;
		buf[p++] = '1';
	}
	for	(i='0';	data > 9; i++) {
		data -=	10;
	}
	buf[p++] = i;
	buf[p++] = data + '0';
	
	return p;
}

void poll_mode(char mode) {
	// pre: camera has sent ':' and is ready for command
	// post: camera has sent ':' and is ready for command
	char inp;
	
	do {
		ser_tx("pm ");
		ser_tx(mode + '0');
		ser_tx("\r");
		// readback ACK\r
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');	
}

char find_red(void) {
	char i, inp;
	unsigned char rmin, rmax;
	unsigned char gbmin, gbmax;
	unsigned char x1, x2;
	
	// initial values
	rmin = 210;	rmax = 255;
	gbmin = 0;	gbmax = 30;
	
	do {
		ser_tx('\r');
		for (i=0; i<7; i++) {
			if ((inp = ser_rx()) == ':') break;
		}
	} while (inp != ':');
	
	poll_mode(1);

	//servo_pos[LW] = LWCTR + 1;  // servo 7 at speed 160	
	// ILLAH : temp change above
	for (rmin = 210; rmin > 160; rmin -= 10) {
		for (gbmax = 30; gbmax < 90; gbmax += 20) {
			// send tc
			buf[0]='t'; buf[1]='c'; buf[2]=' ';
			bp = putbuf(3,rmin);
			buf[bp++] = ' ';
			bp = putbuf(bp,rmax);
			buf[bp++] = ' ';
			bp = putbuf(bp,gbmin);
			buf[bp++] = ' ';
			bp = putbuf(bp,gbmax);
			buf[bp++] = ' ';
			bp = putbuf(bp,gbmin);
			buf[bp++] = ' ';
			bp = putbuf(bp,gbmax);
			buf[bp++] = '\r';
			
			do {
				for (i=0; i<bp; i++) {
					ser_tx(buf[i]);
				}
				inp = ser_rx();
				while (ser_rx() != '\r');
			} while (inp != 'A');
			
			// get response
			if (ser_rx() != 255) {
				return 0;
			}
			if (ser_rx() != 'C') {
				return 0;
			}
			for (bp=0; bp<6; bp++) {
				buf[bp] = ser_rx();
			}
			if (ser_rx() != ':') {
				return 0; // recovery routine???
			}
			
			// interpret packet
			x1 = buf[0];
			x2 = buf[2];
			size = buf[4];
			conf = buf[5];
			
			if ( (!((x1 == 0)&&(x2 == 0))) &&(conf > 30)) {
				// got it!
				poll_mode(0);
				return 1;
			}
		}
	}
	return 0;
	
}

char get_objx(void) {
	char inp, i;
	unsigned char x1, x2, x;
	unsigned char y1, y2, y;
	
	bp = 0;
	// wait for delimiter
	do {
		while (ser_rx() != 255);
	} while (ser_rx() != 'C');
	// grab packet
	for (bp=0; bp<6; bp++) {
		buf[bp] = ser_rx();
	}
			
	// interpret packet
	x1 = buf[0];
	x2 = buf[2];
        y1 = buf[1];
	y2 = buf[3];
	size = buf[4];
	conf = buf[5];
	
	x1 = x1 >> 1;
	x2 = x2 >> 1;
	x = x1 + x2; //object center is between left and right edge

	y1 = y1 >> 1;
	y2 = y2 >> 1;
	y = y1 + y2;
	
	// lowerbound for confidence?
	// if confidence too low, pretend we didn't see anything
	if (conf < 10) { x = 0; y = 0; }
	targetx = x; targety = y;
	return x;
}

void pitch_camera(unsigned char y) {
        unsigned char spos;

	if (y == 0) {
		// object is lost. don't change spoon position //
	} else {
		if ((y > CENTERY+40) && (lastspoonpos < (SPOONMAX - 10))) 
		{
			lastspoonpos = lastspoonpos + 10;
			servo_pos[SW] = lastspoonpos;
                } else
                if ((y < CENTERY-40) && (lastspoonpos > (SPOONMIN + 10)))
		{
			lastspoonpos = lastspoonpos - 10;
			servo_pos[SW] = lastspoonpos;
		} else
		if ((y > CENTERY+10) && (lastspoonpos < (SPOONMAX - 2))) 
		{
			lastspoonpos = lastspoonpos + 2;
			servo_pos[SW] = lastspoonpos;
                } else
                if ((y < CENTERY-10) && (lastspoonpos > (SPOONMIN + 2)))
		{
			lastspoonpos = lastspoonpos - 2;
			servo_pos[SW] = lastspoonpos;
		}
	}
} // pitch_camera() //


void move_camera(char x) {
	char spd; // the speed to turn at //
	if (x == 0) {
		// object is lost
		servo_pos[LW] = 0;
		servo_pos[RW]= 0;
		return;
	}
	else {
		dx = CENTERX - x;
		
		if (abs(dx) < ROTDB) {
			//object is too close to centered. noop
			servo_pos[LW] = 0;
			servo_pos[RW] = 0;
			return;
		}
		if (abs(dx) < ROTSF) { // move slowly
 			spd = SLOW;
		} else {
			spd = FAST;
		}
		if (dx > 0) {  // in this case correct, turn right
			servo_pos[LW] = LWCTR + spd;
			servo_pos[RW]= RWCTR + spd;
			return;			
		}
		else {
			servo_pos[LW] = LWCTR - spd;
			servo_pos[RW] = RWCTR - spd;
		}
	}
}

void main(void) {
	char inp, num, x;
	char turning;

	TSB3 = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	sersoft_init(); // init software serial port
	servo_init();

	servo_state = 1; // activate servo driver

	GIE = 1;

	my_putc("lilbot2\r");

	
	servo_pos[SW] = 190;
	lastspoonpos = 190;
	servo_pos[LW] = LWCTR+2;
	servo_pos[RW]=RWCTR-2;
	delay_ms(1000);
	

	// get camera's attention
	do {
		ser_tx('\r');
		delay_ms(100);
		ser_tx("rm 1\r");
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');

	servo_pos[LW] = 0;
	servo_pos[RW] = 0;

	do {
		ser_tx("cr 19 33\r"); // autogain on, rgb mode
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');

	do {
		ser_tx("mm 0\r"); // mass mode off
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');

	do {
		ser_tx("nf 1\r"); // noise filter on
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');

	do {
		ser_tx("sw\r"); // set full window mode
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');

	servo_pos[LW] = 0;
	servo_pos[RW] = 0;
	delay_ms(500);
	
	// stop moving two motors forward when camera is set up //


	while (1) {
		if (x = find_red()) {
			// found object, go into continuous tracking mode
			 do { 
				ser_tx("tc\r");
				inp = ser_rx();
				while (ser_rx() != '\r');
			} while (inp != 'A'); 			
		}
		while (x != 0) {
			// keep tracking as long as object is found
			x = get_objx(); // x is x-position of target
 			move_camera(targetx);	
			pitch_camera(targety);		
		}
		servo_pos[LW] = 0;
		servo_pos[RW] = 0;

	}
}

