/*
See "CarnegieMellonGraphics.h" for library version info and copyright information
$Id: WindowManager.cpp,v 1.2 2002/10/23 18:50:28 jsaks Exp $
*/

#include <ctime>
#include <CarnegieMellonGraphics.h>
#include <version.h>
#include <Debugging.h>

list<Window *> WindowManager::registeredwindows;
bool WindowManager::handleractive = false;
map<Window *, MouseEvent> WindowManager::mousefilters;
map<Window *, KeyboardEvent> WindowManager::keyfilters;
map<Window *, TimerEvent> WindowManager::timerfilters;

void WindowManager::registerWindow(Window *window) {

  fatal_assert((window == NULL), "How did you do that?  registerWindow has been passed a NULL pointer", __FILE__, __LINE__);

  if(handleractive == true) {
    mousefilters[window] = window->getMouseFilter();
//    window->setMouseFilter(NULL);
    keyfilters[window] = window->getKeyboardFilter();   
//    window->setKeyboardFilter(NULL);
    timerfilters[window] = window->getTimerFilter();   
//    window->setTimerFilter(NULL);
  }

  registeredwindows.push_front(window);
}

void WindowManager::removeWindow(Window *window) {

  fatal_assert((window == NULL), "How did you do that?  removeWindow has been passed a NULL pointer", __FILE__, __LINE__);

  registeredwindows.remove(window);

  if(handleractive == true) {

    fatal_assert((mousefilters.count(window) != 1), 
      "Tried to remove a window that is not in the mousefilter map", __FILE__, __LINE__);

    window->setMouseFilter(mousefilters[window]);
    mousefilters.erase(window);

    fatal_assert((keyfilters.count(window) != 1), 
      "Tried to remove a window that is not in the keyfilter map", __FILE__, __LINE__);

    window->setKeyboardFilter(keyfilters[window]);
    keyfilters.erase(window);

    fatal_assert((timerfilters.count(window) != 1), 
      "Tried to remove a window that is not in the timerfilter map", __FILE__, __LINE__);

    window->setTimerFilter(timerfilters[window]);
    timerfilters.erase(window);
  }
}

void WindowManager::handleEvents() {

  list<Window *>::iterator iterate;

  iterate = registeredwindows.begin();
  while(iterate != registeredwindows.end()) {

    fatal_assert((*iterate == NULL), "There seems to be a NULL pointer in the window list", __FILE__, __LINE__);

    mousefilters[*iterate] = (*iterate)->getMouseFilter();
//    (*iterate)->setMouseFilter(NULL);
    keyfilters[*iterate] = (*iterate)->getKeyboardFilter();
//    (*iterate)->setKeyboardFilter(NULL);
    timerfilters[*iterate] = (*iterate)->getTimerFilter();
//    (*iterate)->setTimerFilter(NULL);
    iterate++;
  }
   
  handleractive = true;
  while(handleractive) {
    // Necessary for doing cooperative threading
    yield();

    iterate = registeredwindows.begin();
    while(iterate != registeredwindows.end()) {
      fatal_assert((*iterate == NULL), "There seems to be a a NULL pointer in the window list", __FILE__, __LINE__);

      while(!(*iterate)->isTimerQueueEmpty())
        (*iterate)->handleTimerEvent((*iterate)->getTimerEvent());

      while(!(*iterate)->isKeyboardQueueEmpty())
        (*iterate)->handleKeyboardEvent((*iterate)->getKeyboardEvent());

      while(!(*iterate)->isMouseQueueEmpty())
        (*iterate)->handleMouseEvent((*iterate)->getMouseEvent());      
 
      (*iterate)->handleIdleEvent();
      
      // Necessary for doing cooperative threading
      yield();
      iterate++;
    }
 
  }

  iterate = registeredwindows.begin();
  while(iterate != registeredwindows.end()) {

    fatal_assert((*iterate == NULL), "There seems to be a NULL pointer in the window list", __FILE__, __LINE__);

    fatal_assert((mousefilters.count(*iterate) != 1), 
      "There is a window in the window list that is not in the mousefilter map", __FILE__, __LINE__);

    (*iterate)->setMouseFilter(mousefilters[*iterate]);
///    mousefilters[*iterate] = NULL;
    mousefilters.erase(*iterate);

    fatal_assert((keyfilters.count(*iterate) != 1), 
      "There is a window in the window list that is not in the keyfilter map.", __FILE__, __LINE__);

    (*iterate)->setKeyboardFilter(keyfilters[*iterate]);
//    keyfilters[*iterate] = NULL;
    keyfilters.erase(*iterate);

    fatal_assert((timerfilters.count(*iterate) != 1), 
      "There is a window in the window list that is not in the timerfilter map.", __FILE__, __LINE__);

    (*iterate)->setTimerFilter(timerfilters[*iterate]);
//    timerfilters[*iterate] = NULL;
    timerfilters.erase(*iterate);
    iterate++;
  }
}

void WindowManager::exitHandler() {
  handleractive = false;
}

unsigned long WindowManager::getTime() {
  return static_cast<unsigned long>(clock());
}
