/*
See "CarnegieMellonGraphics.h" for library version info and copyright information
$Id: PortMutex.h,v 1.1.1.1 2002/10/19 19:02:31 jsaks Exp $
*/

#ifndef __PORTMUTEX_H__
#define __PORTMUTEX_H__

#include <version.h>

// "Portable" Mutual Exclusion (Mutex) Class

class PortMutex {
 private:
 
  #ifdef POSIX_THREADS
    pthread_mutex_t posix_mutex;
  #endif //POSIX_THREADS
  #ifdef BEOS_THREADS
    sem_id beos_mutex;
  #endif //BEOS_THREADS

 public:
  PortMutex(); 
  ~PortMutex();
  void lock();
  void unlock();
};

class Semaphore {
private:
	PortMutex p;
public:
	Semaphore();
	void P(); // "wait"
	void V(); // "signal"
	void wait(); 
	void signal();
};

template <class T>
class SemaphoreT : public Semaphore {
public: 
  T message;
};

#endif //__PORTMUTEX_H__
