/*
See "CarnegieMellonGraphics.h" for library version info and copyright information
$Id: PortMutex.cpp,v 1.2 2002/10/22 19:52:16 jsaks Exp $
*/

#include <PortMutex.h>

PortMutex::PortMutex() {
  #ifdef POSIX_THREADS
    pthread_mutex_init(&posix_mutex, NULL);
  #endif //POSIX_THREADS
  #ifdef BEOS_THREADS
    beos_mutex = create_sem(0, "BeOS Semephore");
  #endif //BEOS_THREADS
}

PortMutex::~PortMutex() {
  #ifdef POSIX_THREADS
    pthread_mutex_destroy(&posix_mutex);
  #endif //POSIX_THREADS
  #ifdef BEOS_THREADS
    delete_sem(beos_mutex);
  #endif //BEOS_THREADS
}

void PortMutex::lock() {
  #ifdef POSIX_THREADS
    pthread_mutex_lock(&posix_mutex);
  #endif //POSIX_THREADS
  #ifdef BEOS_THREADS
    //acquire_sem(beos_mutex);
  #endif //BEOS_THREADS
}

void PortMutex::unlock() {
  #ifdef POSIX_THREADS
    pthread_mutex_unlock(&posix_mutex);
  #endif //POSIX_THREADS
  #ifdef BEOS_THREADS
    //release_sem(beos_mutex);
  #endif //BEOS_THREADS
  }


Semaphore::Semaphore() {
  p.lock();
}

void Semaphore::P() {
  p.lock();
}

void Semaphore::V() {
  p.unlock();
}

void Semaphore::wait() {
  P();
}

void Semaphore::signal() {
  V();
}
