#include "CarnegieMellonGraphics.h"
#include <Daemon.h>

EditableImage::EditableImage(const Image &image) {
  width = image.getWidth();
  height = image.getHeight();
  type = Image::SCREEN;
  imagehandle = Daemon::createEditableImage(image.imagehandle);
  data = Daemon::getImageData(imagehandle);
  editable = true;
}

EditableImage::EditableImage(const EditableImage &image) : Image(image) {
  editable = image.editable;
}

EditableImage::EditableImage(int w, int h) : Image() {
  width = w;
  height = h;
  type = Image::SCREEN;
  imagehandle = Daemon::createEditableImage(width, height);
  data = Daemon::getImageData(imagehandle);
  editable = true;
}

EditableImage &EditableImage::operator=(const EditableImage &rhs) {
  if (rhs.imagehandle == -1) return *this;
  Daemon::releaseImageHandle(imagehandle);
  imagehandle = rhs.imagehandle;
  Daemon::bumpImageRefCount(imagehandle);
  width = rhs.width;
  height = rhs.height;
  type = rhs.type;
  data = rhs.data;
  editable = rhs.editable;
  return *this;
}

EditableImage::~EditableImage() {
  if (imagehandle != -1) {
    Daemon::releaseImageHandle(imagehandle);
  }
}

inline Color EditableImage::getPixel(int x, int y) {
  if (x < 0 || x >= width || y < 0 || y >= width) return Color(0,0,0,0);
  unsigned char *pixel = (data+(y*width*4)+x*4);
  return Color(pixel[0], pixel[1], pixel[2], pixel[3]);
}

inline void EditableImage::setPixel(const Color &c, int x, int y) {
  if (x < 0 || x >= width || y < 0 || y >= height) return;
  unsigned char *pixel = (data+(y*width*4)+x*4);
  pixel[0] = c.getRed();
  pixel[1] = c.getGreen();
  pixel[2] = c.getBlue();
  pixel[3] = c.getAlpha();
}

EditableImage EditableImage::clone() {
  return clone(imagehandle, width, height);
}

EditableImage EditableImage::clone(int imagehandle, int width, int height) {
  return EditableImage(imagehandle, width, height);
}

EditableImage::EditableImage(int imagehandle, int w, int h) {
  width = w;
  height = h;
  type = Image::SCREEN;
  imagehandle = Daemon::createEditableImage(imagehandle);
  editable = true;
}
