/*
 * Decompiled with CFR 0.152.
 */
package test;

import edu.umd.coral.clustering.LAPAwesomeReordering;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.BitSymmetricMatrix;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.MyMTJMatrix;
import edu.umd.coral.model.parse.ModuleFilesParser;
import java.util.Map;
import javax.swing.JFrame;
import junit.framework.TestCase;

public class TestParsers
extends TestCase {
    public void testModuleParser() throws Exception {
        DataModel model = new DataModel(new JFrame("blah!"));
        ModuleFilesParser parser = new ModuleFilesParser();
        String path = "/home/lynxoid/Dropbox/coral/svn/coral_cluster/data/test/";
        String[] files = new String[]{String.valueOf(path) + "clustering1", String.valueOf(path) + "clustering2"};
        parser.parse(files, model);
        Map<String, Clustering> clusterings = model.getClusterings();
        Clustering c1 = clusterings.get("clustering1");
        Clustering c2 = clusterings.get("clustering2");
        TestParsers.assertEquals((int)2, (int)c1.getModuleCount());
        TestParsers.assertEquals((int)3, (int)c2.getModuleCount());
        try {
            int n;
            String[] vertexNames;
            c1.createCooccurenceMatrix();
            c2.createCooccurenceMatrix();
            BitSymmetricMatrix bsm = c1.getCoocurenceMatrix();
            BitSymmetricMatrix bsm2 = c2.getCoocurenceMatrix();
            this.checkRowValues(bsm);
            int rowSum = 0;
            String[] stringArray = vertexNames = new String[]{"v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10"};
            int n2 = vertexNames.length;
            int n3 = 0;
            while (n3 < n2) {
                String u = stringArray[n3];
                rowSum = 0;
                String[] stringArray2 = vertexNames;
                int n4 = vertexNames.length;
                n = 0;
                while (n < n4) {
                    String v = stringArray2[n];
                    rowSum = (int)((double)rowSum + bsm.getElement(bsm.getRowIndex(u), bsm.getRowIndex(v)));
                    ++n;
                }
                TestParsers.assertEquals((int)5, (int)rowSum);
                ++n3;
            }
            this.checkRowValues2(bsm2);
            int[] rowSums = new int[]{3, 3, 3, 3, 3, 3, 4, 4, 4, 4};
            int i = 0;
            while (i < 10) {
                String u = vertexNames[i];
                rowSum = 0;
                String[] stringArray3 = vertexNames;
                n = vertexNames.length;
                int v = 0;
                while (v < n) {
                    String v2 = stringArray3[v];
                    rowSum = (int)((double)rowSum + bsm2.getElement(bsm2.getRowIndex(u), bsm2.getRowIndex(v2)));
                    ++v;
                }
                TestParsers.assertEquals((int)rowSums[i], (int)rowSum);
                ++i;
            }
            MyMTJMatrix sum = new MyMTJMatrix(10);
            sum.addMatrix(bsm);
            sum.addMatrix(bsm2);
            sum.columnNames = bsm.rowNames;
            sum.rowNames = bsm.rowNames;
            this.checkSumsRows(sum);
            LAPAwesomeReordering so = new LAPAwesomeReordering(1, 0);
            Matrix rMatrix = so.reorder(sum);
            int[] sumRowSums = new int[]{8, 8, 8, 8, 8, 8, 9, 9, 9, 9};
            int i2 = 0;
            while (i2 < 10) {
                String u = vertexNames[i2];
                rowSum = 0;
                String[] stringArray4 = vertexNames;
                int n5 = vertexNames.length;
                int n6 = 0;
                while (n6 < n5) {
                    String v = stringArray4[n6];
                    rowSum = (int)((double)rowSum + rMatrix.getElement(rMatrix.getRowIndex(u), rMatrix.getRowIndex(v)));
                    ++n6;
                }
                TestParsers.assertEquals((int)sumRowSums[i2], (int)rowSum);
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkSumsRows(MyMTJMatrix sum) {
        TestParsers.assertEquals((Object)Float.valueOf(2.0f), (Object)sum.getElement(sum.getRowIndex("v1"), sum.getRowIndex("v2")));
        TestParsers.assertEquals((Object)Float.valueOf(2.0f), (Object)sum.getElement(sum.getRowIndex("v1"), sum.getRowIndex("v3")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)sum.getElement(sum.getRowIndex("v1"), sum.getRowIndex("v4")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)sum.getElement(sum.getRowIndex("v1"), sum.getRowIndex("v5")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v1"), sum.getRowIndex("v6")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v1"), sum.getRowIndex("v7")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v1"), sum.getRowIndex("v8")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v1"), sum.getRowIndex("v9")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v1"), sum.getRowIndex("v10")));
        TestParsers.assertEquals((Object)Float.valueOf(2.0f), (Object)sum.getElement(sum.getRowIndex("v2"), sum.getRowIndex("v1")));
        TestParsers.assertEquals((Object)Float.valueOf(2.0f), (Object)sum.getElement(sum.getRowIndex("v2"), sum.getRowIndex("v3")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)sum.getElement(sum.getRowIndex("v2"), sum.getRowIndex("v4")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)sum.getElement(sum.getRowIndex("v2"), sum.getRowIndex("v5")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v2"), sum.getRowIndex("v6")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v2"), sum.getRowIndex("v7")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v2"), sum.getRowIndex("v8")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v2"), sum.getRowIndex("v9")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)sum.getElement(sum.getRowIndex("v2"), sum.getRowIndex("v10")));
    }

    private void checkRowValues2(BitSymmetricMatrix bsm2) {
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v1"), bsm2.getRowIndex("v2")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v1"), bsm2.getRowIndex("v3")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v1"), bsm2.getRowIndex("v4")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v1"), bsm2.getRowIndex("v5")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v1"), bsm2.getRowIndex("v6")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v1"), bsm2.getRowIndex("v7")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v1"), bsm2.getRowIndex("v8")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v1"), bsm2.getRowIndex("v9")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v1"), bsm2.getRowIndex("v10")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v2"), bsm2.getRowIndex("v1")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v2"), bsm2.getRowIndex("v3")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v2"), bsm2.getRowIndex("v4")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v2"), bsm2.getRowIndex("v5")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v2"), bsm2.getRowIndex("v6")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v2"), bsm2.getRowIndex("v7")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v2"), bsm2.getRowIndex("v8")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v2"), bsm2.getRowIndex("v9")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm2.getElement(bsm2.getRowIndex("v2"), bsm2.getRowIndex("v10")));
    }

    private void checkRowValues(BitSymmetricMatrix bsm) {
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm.getElement(bsm.getRowIndex("v1"), bsm.getRowIndex("v2")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm.getElement(bsm.getRowIndex("v1"), bsm.getRowIndex("v3")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm.getElement(bsm.getRowIndex("v1"), bsm.getRowIndex("v4")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm.getElement(bsm.getRowIndex("v1"), bsm.getRowIndex("v5")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v1"), bsm.getRowIndex("v6")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v1"), bsm.getRowIndex("v7")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v1"), bsm.getRowIndex("v8")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v1"), bsm.getRowIndex("v9")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v1"), bsm.getRowIndex("v10")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm.getElement(bsm.getRowIndex("v2"), bsm.getRowIndex("v1")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm.getElement(bsm.getRowIndex("v2"), bsm.getRowIndex("v3")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm.getElement(bsm.getRowIndex("v2"), bsm.getRowIndex("v4")));
        TestParsers.assertEquals((Object)Float.valueOf(1.0f), (Object)bsm.getElement(bsm.getRowIndex("v2"), bsm.getRowIndex("v5")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v2"), bsm.getRowIndex("v6")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v2"), bsm.getRowIndex("v7")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v2"), bsm.getRowIndex("v8")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v2"), bsm.getRowIndex("v9")));
        TestParsers.assertEquals((Object)Float.valueOf(0.0f), (Object)bsm.getElement(bsm.getRowIndex("v2"), bsm.getRowIndex("v10")));
    }
}

