/*
 * Decompiled with CFR 0.152.
 */
package test;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.metrics.FMeasureMetric;
import edu.umd.coral.model.metrics.InversePurity;
import edu.umd.coral.model.metrics.JaccardMetric;
import edu.umd.coral.model.metrics.PurityMetric;
import junit.framework.TestCase;

public class TestMetrics
extends TestCase {
    Clustering A;
    Clustering B;
    float precision = 1.0E-5f;

    public void setUp() {
        this.A = new Clustering("A");
        this.B = new Clustering("B");
    }

    private void getEqualClust() throws Exception {
        Module m = new Module("m1", this.A);
        m.addVertex(new Vertex("a"));
        m.addVertex(new Vertex("b"));
        m.addVertex(new Vertex("c"));
        m.addVertex(new Vertex("d"));
        m.addVertex(new Vertex("e"));
        m.addVertex(new Vertex("f"));
        this.A.addModule(m);
        this.B.addModule(m);
    }

    private void getHalfAndWholeClust() throws Exception {
        this.A.clear();
        this.B.clear();
        Module m = new Module("m1", this.A);
        m.addVertex(new Vertex("a"));
        m.addVertex(new Vertex("b"));
        m.addVertex(new Vertex("c"));
        this.A.addModule(m);
        m = new Module("m2", this.A);
        m.addVertex(new Vertex("d"));
        m.addVertex(new Vertex("e"));
        m.addVertex(new Vertex("f"));
        this.A.addModule(m);
        m = new Module("m3", this.B);
        m.addVertex(new Vertex("a"));
        m.addVertex(new Vertex("b"));
        m.addVertex(new Vertex("c"));
        m.addVertex(new Vertex("d"));
        m.addVertex(new Vertex("e"));
        m.addVertex(new Vertex("f"));
        this.B.addModule(m);
    }

    private void getUnequalAndWholeClust() throws Exception {
        this.A.clear();
        this.B.clear();
        Module m = new Module("m1", this.A);
        m.addVertex(new Vertex("a"));
        m.addVertex(new Vertex("b"));
        m.addVertex(new Vertex("c"));
        m.addVertex(new Vertex("d"));
        this.A.addModule(m);
        m = new Module("m2", this.A);
        m.addVertex(new Vertex("e"));
        m.addVertex(new Vertex("f"));
        this.A.addModule(m);
        m = new Module("m3", this.B);
        m.addVertex(new Vertex("a"));
        m.addVertex(new Vertex("b"));
        m.addVertex(new Vertex("c"));
        m.addVertex(new Vertex("d"));
        m.addVertex(new Vertex("e"));
        m.addVertex(new Vertex("f"));
        this.B.addModule(m);
    }

    private void getUnequalClust() throws Exception {
        this.A.clear();
        this.B.clear();
        Module m = new Module("m1", this.A);
        m.addVertex(new Vertex("a"));
        m.addVertex(new Vertex("b"));
        m.addVertex(new Vertex("c"));
        m.addVertex(new Vertex("d"));
        this.A.addModule(m);
        m = new Module("m2", this.A);
        m.addVertex(new Vertex("e"));
        m.addVertex(new Vertex("f"));
        this.A.addModule(m);
        m = new Module("m3", this.B);
        m.addVertex(new Vertex("a"));
        m.addVertex(new Vertex("b"));
        m.addVertex(new Vertex("c"));
        this.B.addModule(m);
        m = new Module("m4", this.B);
        m.addVertex(new Vertex("d"));
        m.addVertex(new Vertex("e"));
        m.addVertex(new Vertex("f"));
        this.B.addModule(m);
    }

    public void testPurity() throws Exception {
        PurityMetric p = new PurityMetric();
        this.getEqualClust();
        float score = p.getScore(this.A, this.B, false);
        TestMetrics.assertEquals((float)1.0f, (float)score, (float)this.precision);
        this.getHalfAndWholeClust();
        score = p.getScore(this.A, this.B, true);
        TestMetrics.assertEquals((double)1.0, (double)score, (double)this.precision);
        this.getUnequalClust();
        score = p.getScore(this.A, this.B, true);
        TestMetrics.assertEquals((double)0.8333333333333334, (double)score, (double)this.precision);
    }

    public void testInvPurity() throws Exception {
        InversePurity p = new InversePurity();
        this.getEqualClust();
        float score = p.getScore(this.A, this.B, false);
        TestMetrics.assertEquals((float)1.0f, (float)score, (float)this.precision);
        this.getHalfAndWholeClust();
        score = p.getScore(this.A, this.B, true);
        TestMetrics.assertEquals((double)1.0, (double)score, (double)this.precision);
        this.getUnequalAndWholeClust();
        score = p.getScore(this.A, this.B, true);
        System.out.println("InvPurity " + score);
        TestMetrics.assertEquals((double)0.6666666666666666, (double)score, (double)this.precision);
        this.getUnequalClust();
        score = p.getScore(this.A, this.B, true);
        System.out.println("InvPurity " + score);
        TestMetrics.assertEquals((double)0.8333333333333334, (double)score, (double)this.precision);
    }

    public void testFolkes() {
    }

    public void testJaccard() throws Exception {
        JaccardMetric metric = new JaccardMetric();
        this.getEqualClust();
        this.A.createCooccurenceMatrix();
        this.B.createCooccurenceMatrix();
        float j = metric.getScore(this.A, this.B, false);
        TestMetrics.assertEquals((float)1.0f, (float)j, (float)this.precision);
        this.A.clear();
        this.B.clear();
        this.getHalfAndWholeClust();
        this.A.createCooccurenceMatrix();
        this.B.createCooccurenceMatrix();
        j = metric.getScore(this.A, this.B, false);
        TestMetrics.assertEquals((double)0.4, (double)j, (double)this.precision);
    }

    public void testJaccardGrabBag() {
        this.A.createCooccurenceMatrix();
        this.B.createCooccurenceMatrix();
    }

    public void testRand() {
    }

    public void testMirkin() {
    }

    public void testVI() {
    }

    public void testFmeasure() throws Exception {
        FMeasureMetric metric = new FMeasureMetric();
        this.getEqualClust();
        float score = metric.getScore(this.B, this.A, true);
        TestMetrics.assertEquals((double)1.0, (double)score, (double)this.precision);
        this.A.clear();
        this.B.clear();
        this.getHalfAndWholeClust();
        score = metric.getScore(this.B, this.A, true);
        TestMetrics.assertEquals((double)0.6666666666666666, (double)score, (double)this.precision);
        this.getUnequalAndWholeClust();
        score = metric.getScore(this.B, this.A, true);
        TestMetrics.assertEquals((double)0.8, (double)score, (double)this.precision);
        this.getUnequalClust();
        score = metric.getScore(this.B, this.A, true);
        TestMetrics.assertEquals((float)0.82857144f, (float)score, (float)this.precision);
    }
}

