/*
 * Decompiled with CFR 0.152.
 */
package test;

import edu.umd.coral.model.data.Matrix;
import junit.framework.TestCase;

public class TestMatrix
extends TestCase {
    public void testConnectedComponentsDisjoint() {
        double[][] data = new double[][]{{1.0, 2.0, 0.0, 0.0, 0.0}, {2.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 3.0, 2.0, 1.0}, {0.0, 0.0, 2.0, 3.0, 2.0}, {0.0, 0.0, 1.0, 2.0, 3.0}};
        String[] names = new String[]{"a", "b", "c", "d", "e"};
        Matrix m = new Matrix(data, names, names, 3.0);
        Matrix[] comp = Matrix.getConnectedComponents(m);
        TestMatrix.assertTrue(((m = comp[0]).getElement(0, 0) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(0, 1) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 0) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 1) == 1.0 ? 1 : 0) != 0);
        m = comp[1];
        TestMatrix.assertTrue((m.getElement(0, 0) == 3.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(0, 1) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(0, 2) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 0) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 1) == 3.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 2) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(2, 0) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(2, 1) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(2, 2) == 3.0 ? 1 : 0) != 0);
        double[][] data2 = new double[][]{{1.0, 0.0, 0.0, 2.0, 0.0}, {0.0, 3.0, 2.0, 0.0, 2.0}, {0.0, 2.0, 3.0, 0.0, 1.0}, {2.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 2.0, 1.0, 0.0, 3.0}};
        String[] names2 = new String[]{"a", "d", "c", "b", "e"};
        m = new Matrix(data2, names2, names2, 3.0);
        comp = Matrix.getConnectedComponents(m);
        m = comp[0];
        TestMatrix.assertTrue((m.getElement(0, 0) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(0, 1) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 0) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 1) == 1.0 ? 1 : 0) != 0);
        m = comp[1];
        TestMatrix.assertTrue((m.getElement(0, 0) == 3.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(0, 1) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(0, 2) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 0) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 1) == 3.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(1, 2) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(2, 0) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(2, 1) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m.getElement(2, 2) == 3.0 ? 1 : 0) != 0);
    }

    public void testMergeComponents() {
        double[][] data = new double[][]{{1.0, 2.0}, {3.0, 4.0}};
        String[] names = new String[]{"a", "b"};
        Matrix m = new Matrix(data, names, names);
        double[][] data2 = new double[][]{{5.0, 6.0}, {7.0, 8.0}};
        String[] names2 = new String[]{"c", "d"};
        Matrix m2 = new Matrix(data2, names2, names2);
        Matrix[] array = new Matrix[]{m, m2};
        Matrix m12 = Matrix.mergeComponents(array, 8.0);
        TestMatrix.assertTrue((m12.getElement(0, 0) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(0, 1) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(1, 0) == 3.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(1, 1) == 4.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(0, 2) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(0, 3) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(1, 2) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(1, 3) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(2, 0) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(2, 1) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(3, 0) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(3, 1) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(2, 2) == 5.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(2, 3) == 6.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(3, 2) == 7.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((m12.getElement(3, 3) == 8.0 ? 1 : 0) != 0);
    }

    public void testConnectedComponentsSingle() {
        double[][] data = new double[][]{{0.0, 0.0, 1.0, 2.0}, {0.0, 0.0, 3.0, 4.0}, {1.0, 3.0, 0.0, 0.0}, {2.0, 4.0, 0.0, 0.0}};
        String[] names = new String[]{"a", "b", "c", "d"};
        Matrix matrix = new Matrix(data, names, names);
        Matrix[] comp = Matrix.getConnectedComponents(matrix);
        TestMatrix.assertTrue((comp.length == 1 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(0, 0) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(0, 1) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(0, 2) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(0, 3) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(1, 0) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(1, 1) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(1, 2) == 3.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(1, 3) == 4.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(2, 0) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(2, 1) == 3.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(2, 2) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(2, 3) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(3, 0) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(3, 1) == 4.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(3, 2) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(3, 3) == 0.0 ? 1 : 0) != 0);
    }

    public void testConnectedComponentsSingle2() {
        double[][] data = new double[][]{{0.0, 0.0, 1.0, 2.0}, {0.0, 0.0, 3.0, 4.0}, {1.0, 3.0, 0.0, 0.0}, {2.0, 4.0, 0.0, 0.0}};
        String[] names = new String[]{"a", "b", "c", "d"};
        Matrix matrix = new Matrix(data, names, names);
        Matrix[] comp = Matrix.getConnectedComponents2(matrix);
        TestMatrix.assertTrue((comp.length == 1 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(0, 0) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(0, 1) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(0, 2) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(0, 3) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(1, 0) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(1, 1) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(1, 2) == 3.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(1, 3) == 4.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(2, 0) == 1.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(2, 1) == 3.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(2, 2) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(2, 3) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(3, 0) == 2.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(3, 1) == 4.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(3, 2) == 0.0 ? 1 : 0) != 0);
        TestMatrix.assertTrue((comp[0].getElement(3, 3) == 0.0 ? 1 : 0) != 0);
    }

    public void testBandwidth() {
        double[][] data = new double[][]{{1.0, 2.0, 0.0, 1.0, 0.0}, {2.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 3.0, 2.0, 0.0}, {1.0, 0.0, 2.0, 3.0, 2.0}, {0.0, 0.0, 0.0, 2.0, 3.0}};
        String[] names = new String[]{"a", "b", "c", "d", "e"};
        Matrix matrix = new Matrix(data, names, names);
        int band = matrix.getBandwidth();
        System.out.println(band);
        TestMatrix.assertTrue((band == 5 ? 1 : 0) != 0);
    }

    public void testReorder() {
        double[][] data1 = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        String[] names1 = new String[]{"a", "b", "c"};
        double[][] data2 = new double[][]{{5.0, 4.0, 6.0}, {2.0, 1.0, 3.0}, {8.0, 7.0, 9.0}};
        String[] names2 = new String[]{"b", "a", "c"};
        Matrix m1 = new Matrix(data1, names1, names1);
        Matrix m2 = new Matrix(data2, names2, names2);
        Matrix reorder = Matrix.reorderSubMatrix(m1, m2);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                TestMatrix.assertEquals((Object)reorder.getElement(i, j), (Object)m2.getElement(i, j));
                ++j;
            }
            ++i;
        }
    }

    public void testReorder2() {
        double[][] data1 = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        String[] names1 = new String[]{"a", "b", "c"};
        double[][] data2 = new double[][]{{9.0, 7.0, 8.0}, {3.0, 1.0, 2.0}, {6.0, 4.0, 5.0}};
        String[] names2 = new String[]{"c", "a", "b"};
        Matrix m1 = new Matrix(data1, names1, names1);
        Matrix m2 = new Matrix(data2, names2, names2);
        Matrix reorder = Matrix.reorderSubMatrix(m1, m2);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                TestMatrix.assertEquals((Object)reorder.getElement(i, j), (Object)m2.getElement(i, j));
                ++j;
            }
            ++i;
        }
    }
}

