/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.tabs;

import edu.umd.coral.managers.ModuleOrderManager;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.panel.HasSaveableImage;
import edu.umd.coral.ui.panel.ZoomableParallelSets;
import edu.umd.coral.ui.tabs.PPDataModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelSetsPanel
extends JPanelExt
implements ComponentListener,
PropertyChangeListener,
HasSaveableImage,
AdjustmentListener {
    private static final long serialVersionUID = -7175354079615188081L;
    private ZoomableParallelSets vis;
    private PPDataModel ppdm;

    public ParallelSetsPanel(DataModel model) {
        super(model);
        this.setLayout(new BorderLayout());
        this.ppdm = new PPDataModel(this);
        this.ppdm.addPropertyChangeListener("selectedVertChangeFromPP", this);
        this.vis = new ZoomableParallelSets(this.ppdm);
        this.vis.setShowPartitionItems(model.getShowPItems());
        this.vis.setShowPartitionLabels(model.getShowPLabels());
        JScrollPane pane = new JScrollPane(this.vis);
        pane.getHorizontalScrollBar().addAdjustmentListener(this);
        pane.getVerticalScrollBar().addAdjustmentListener(this);
        pane.addComponentListener(this);
        this.add(pane);
        model.addPropertyChangeListener("moduleSpacingChanged", this);
        model.addPropertyChangeListener("currentMatrixChanged", this);
        model.addPropertyChangeListener("clusteringsChanged", this);
        model.addPropertyChangeListener("selectedVerticesChanged", this);
        model.addPropertyChangeListener("searchItemChanged", this);
        model.addPropertyChangeListener("metricsScoresChanged", this);
        model.addPropertyChangeListener("showPItemsChanged", this);
        model.addPropertyChangeListener("showPLabelsChanged", this);
        model.addPropertyChangeListener("ppClusteringOrderingChanged", this);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.vis.revalidate();
        this.vis.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("moduleSpacingChanged")) {
            this.vis.setModuleSpacing(this._dataModel.getModuleSpacing());
        } else if (name.equals("clusteringsChanged") || name.equals("currentMatrixChanged")) {
            ArrayList<Clustering> axisOrdering = this._dataModel.getClusteringOrdering();
            if (axisOrdering == null || this._dataModel.getCurrentMatrix() == null) {
                this.vis.setOrderings(null);
            } else {
                ModuleOrderManager mom = new ModuleOrderManager();
                Matrix m = this._dataModel.getCurrentMatrix();
                ArrayList<ArrayList<Module>> moduleOrdering = new ArrayList<ArrayList<Module>>();
                for (Clustering c : axisOrdering) {
                    moduleOrdering.add(mom.getOrdering(c, m.columnNames, 2));
                }
                this.vis.setOrderings(moduleOrdering);
            }
            this._dataModel.removePropertyChangeListener("ppClusteringOrderingChanged", this);
            this._dataModel.setPPClusteringOrdering(axisOrdering);
            this._dataModel.addPropertyChangeListener("ppClusteringOrderingChanged", this);
            this.vis.setCollection(axisOrdering);
            this.vis.invalidateData();
        } else if (name.equals("searchItemChanged")) {
            Vertex u = this._dataModel.getSearchItem();
            ArrayList<Vertex> a = new ArrayList<Vertex>();
            a.add(u);
            this.vis.setSelectedVertices(a);
        } else if (name.equals("selectedVerticesChanged")) {
            ArrayList<Vertex> collection = this._dataModel.getSelectedVertices();
            this.vis.setSelectedVertices(collection);
        } else if (name.equals("showPLabelsChanged")) {
            this.vis.setShowPartitionLabels(this._dataModel.getShowPLabels());
        } else if (name.equals("showPItemsChanged")) {
            this.vis.setShowPartitionItems(this._dataModel.getShowPItems());
        } else if (name.equals("selectedVertChangeFromPP")) {
            this._dataModel.removePropertyChangeListener("selectedVerticesChanged", this);
            this._dataModel.setSelectedVertices(this.ppdm.getSelectedVertices());
            this._dataModel.addPropertyChangeListener("selectedVerticesChanged", this);
        } else if (name.equals("ppClusteringOrderingChanged")) {
            ArrayList<Clustering> axisOrdering = this._dataModel.getPPClusteringOrdering();
            if (axisOrdering == null || this._dataModel.getCurrentMatrix() == null) {
                this.vis.setOrderings(null);
            } else {
                ModuleOrderManager mom = new ModuleOrderManager();
                Matrix m = this._dataModel.getCurrentMatrix();
                ArrayList<ArrayList<Module>> moduleOrdering = new ArrayList<ArrayList<Module>>();
                for (Clustering c : axisOrdering) {
                    moduleOrdering.add(mom.getOrdering(c, m.columnNames, 2));
                }
                this.vis.setOrderings(moduleOrdering);
            }
            this.vis.setCollection(this._dataModel.getPPClusteringOrdering());
            this.vis.invalidateData();
        }
        this.vis.revalidate();
        this.vis.repaint();
    }

    private static void createAndShowGUI() throws Exception {
        JFrame frame = new JFrame("FrameDemo");
        frame.setDefaultCloseOperation(3);
        frame.setLocation(300, 300);
        DataModel dm = new DataModel(frame);
        dm.setShowPItems(true);
        ParallelSetsPanel psp = new ParallelSetsPanel(dm);
        Map<String, Clustering> clusterings = ParallelSetsPanel.makeClusterings();
        ArrayList<Clustering> list = new ArrayList<Clustering>();
        for (Clustering c : clusterings.values()) {
            list.add(c);
        }
        double[][] data = new double[][]{new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[0]};
        String[] names = new String[]{"c", "a", "b", "x", "d", "f", "g", "e"};
        Matrix m = new Matrix(data, names, names);
        dm.setOriginalMatrix(m);
        dm.setCurrentMatrix(m);
        dm.setClusteringOrdering(list);
        psp.vis.setCollection(list);
        ArrayList<ArrayList<Module>> moduleOrdering = new ArrayList<ArrayList<Module>>();
        ModuleOrderManager mom = new ModuleOrderManager();
        for (Clustering c : list) {
            moduleOrdering.add(mom.getOrdering(c, names, 2));
        }
        psp.vis.setOrderings(moduleOrdering);
        ArrayList<Vertex> coll = new ArrayList<Vertex>();
        coll.add(list.get(0).getVertices()[0]);
        coll.add(list.get(0).getVertices()[1]);
        dm.setSelectedVertices(coll);
        frame.getContentPane().setPreferredSize(new Dimension(300, 300));
        frame.getContentPane().add(psp);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ParallelSetsPanel.createAndShowGUI();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static Map<String, Clustering> makeClusterings() throws Exception {
        HashMap<String, Clustering> clusterings = new HashMap<String, Clustering>();
        Clustering c1 = new Clustering("clust2");
        c1.setColor(new Color(27, 158, 119));
        Module m = new Module("m1", c1);
        Vertex v = new Vertex("a");
        m.addVertex(v);
        v = new Vertex("b");
        m.addVertex(v);
        v = new Vertex("x");
        m.addVertex(v);
        v = new Vertex("c");
        m.addVertex(v);
        v = new Vertex("d");
        m.addVertex(v);
        c1.addModule(m);
        m = new Module("m2", c1);
        v = new Vertex("e");
        m.addVertex(v);
        v = new Vertex("f");
        m.addVertex(v);
        v = new Vertex("g");
        m.addVertex(v);
        c1.addModule(m);
        c1.setOriginalVertexCount(8);
        clusterings.put("clust2", c1);
        c1 = new Clustering("clust1");
        c1.setColor(new Color(217, 95, 2));
        m = new Module("m1", c1);
        v = new Vertex("a");
        m.addVertex(v);
        v = new Vertex("b");
        m.addVertex(v);
        v = new Vertex("d");
        m.addVertex(v);
        c1.addModule(m);
        m = new Module("m2", c1);
        v = new Vertex("c");
        m.addVertex(v);
        v = new Vertex("e");
        m.addVertex(v);
        c1.addModule(m);
        m = new Module("m3", c1);
        v = new Vertex("f");
        m.addVertex(v);
        v = new Vertex("g");
        m.addVertex(v);
        c1.addModule(m);
        c1.setOriginalVertexCount(7);
        clusterings.put("clust1", c1);
        return clusterings;
    }

    @Override
    public RenderedImage getImage() {
        return this.vis.getImage();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ev) {
        this.vis.updateLabels();
    }
}

