/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.tabs;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.panel.BarChartPanel;
import edu.umd.coral.ui.panel.HasSaveableImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.RenderedImage;
import javax.swing.JTabbedPane;

public class OverviewTab
extends JPanelExt
implements HasSaveableImage {
    private static final long serialVersionUID = -2234248829627364985L;
    private JTabbedPane tabbedPane;

    public OverviewTab(DataModel model) {
        super(model);
        this._dataModel = model;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(3);
        this.add(this.tabbedPane);
        BarChartPanel panel = new BarChartPanel(this._dataModel, "module count", "clusteringsChanged", "int");
        this.tabbedPane.addTab("Mod cnt", null, panel, "Module count in each clustering");
        panel = new BarChartPanel(this._dataModel, "Avg. module size", "clusteringsChanged", "float");
        this.tabbedPane.addTab("Avg Mod size", null, panel, "Average module size per clustering");
        panel = new BarChartPanel(this._dataModel, "Avg. density", "networkLoaded", "float");
        this.tabbedPane.addTab("Avg Mod Dens", null, panel, "Average module density (available only if network information is loaded)");
        panel = new BarChartPanel(this._dataModel, "Vertex count", "clusteringsChanged", "int");
        this.tabbedPane.addTab("Vtx cnt", null, panel, "Vertex count per clustering");
        panel = new BarChartPanel(this._dataModel, "Entropy", "clusteringsChanged", "float");
        this.tabbedPane.addTab("Entropy", null, panel, "Entropy for each clustering");
        panel = new BarChartPanel(this._dataModel, "Overlap", "clusteringsChanged", "float");
        this.tabbedPane.addTab("Overlap", null, panel, "Percent of vertices that are in more than one cluster");
    }

    public RenderedImage getImage() {
        Component c = this.tabbedPane.getSelectedComponent();
        if (c instanceof BarChartPanel) {
            BarChartPanel bcp = (BarChartPanel)c;
            return bcp.getImage();
        }
        return null;
    }
}

