/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.tabs;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.GradientColorModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.ModulePair;
import edu.umd.coral.model.data.Score;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.metrics.Metric;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.slider.RangeSlider;
import edu.umd.coral.ui.table.ClusteringCompareTableModel;
import edu.umd.coral.ui.table.ClusteringCompareTableSorter;
import edu.umd.coral.ui.table.renderer.JaccardCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module2ModulePanel
extends JPanelExt
implements ActionListener,
PropertyChangeListener,
ChangeListener,
ListSelectionListener {
    private JTable table;
    private JLabel detail;
    private RangeSlider slider;
    private ClusteringCompareTableModel tableModel;
    private static final long serialVersionUID = -4344345902768705907L;

    public Module2ModulePanel(DataModel model) {
        super(model);
        this._dataModel.addPropertyChangeListener("metricsScoresChanged", this);
        this._dataModel.addPropertyChangeListener("selectedClustPairChanged", this);
        this._dataModel.addPropertyChangeListener("moduleTableColumnsChanged", this);
        this._dataModel.addPropertyChangeListener("selectedVerticesChanged", this);
        this._dataModel.addPropertyChangeListener("searchItemChanged", this);
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.initHeaderUI();
        this.initTableUI();
    }

    private void initTableUI() {
        this.table = new JTable(){
            private static final long serialVersionUID = -4676300440118445967L;

            public TableCellRenderer getCellRenderer(int row, int column) {
                ClusteringCompareTableModel v2vm;
                int index;
                TableModel model = this.getModel();
                if (model instanceof ClusteringCompareTableModel && (index = (v2vm = (ClusteringCompareTableModel)model).getColumnIndex("Jaccard")) == column) {
                    return new JaccardCellRenderer(true);
                }
                return super.getCellRenderer(row, column);
            }

            public String getToolTipText(MouseEvent e) {
                String tip;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realRowIndex = this.convertRowIndexToModel(rowIndex);
                String colName = this.getColumnName(colIndex);
                if (colName.equals("m1 \u2229 m2") || colName.equals("m1 \\ m2") || colName.equals("m2 \\ m1")) {
                    tip = Module2ModulePanel.this.tableModel.getToolTipAt(realRowIndex, colName);
                    if (tip == null || tip.equals("")) {
                        tip = "Empty";
                    }
                } else {
                    tip = super.getToolTipText(e);
                }
                return tip;
            }
        };
        this.tableModel = new ClusteringCompareTableModel();
        ClusteringCompareTableSorter sorter = new ClusteringCompareTableSorter(this.tableModel);
        this._dataModel.setModuleTableColumns(this.tableModel.getSelectedColumnNames());
        this.table.setModel(this.tableModel);
        this.table.setRowSorter(sorter);
        this.table.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setAlignmentX(0.0f);
        this.add((Component)scrollPane, "Center");
    }

    private void initHeaderUI() {
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        this.detail = new JLabel("Selected:");
        this.detail.setAlignmentX(0.0f);
        header.add(this.detail);
        this.slider = new RangeSlider();
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(10);
        this.slider.setMinorTickSpacing(5);
        this.slider.setDrawGradient(true);
        Hashtable<Integer, JLabel> d = new Hashtable<Integer, JLabel>();
        ((Dictionary)d).put(0, new JLabel("0.0"));
        ((Dictionary)d).put(10, new JLabel("0.1"));
        ((Dictionary)d).put(20, new JLabel("0.2"));
        ((Dictionary)d).put(30, new JLabel("0.3"));
        ((Dictionary)d).put(40, new JLabel("0.4"));
        ((Dictionary)d).put(50, new JLabel("0.5"));
        ((Dictionary)d).put(60, new JLabel("0.6"));
        ((Dictionary)d).put(70, new JLabel("0.7"));
        ((Dictionary)d).put(80, new JLabel("0.8"));
        ((Dictionary)d).put(90, new JLabel("0.9"));
        ((Dictionary)d).put(100, new JLabel("1.0"));
        this.slider.setLabelTable(d);
        this.slider.setMinimum(0);
        this.slider.setMaximum(100);
        this.slider.setValue(0);
        this.slider.setUpperValue(100);
        this.slider.setAlignmentX(0.0f);
        this.slider.addChangeListener(this);
        header.add(this.slider);
        this.add((Component)header, "First");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox combo = (JComboBox)e.getSource();
        Metric selectedMetric = (Metric)combo.getSelectedItem();
        this._dataModel.setSelectedMetric(selectedMetric);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("moduleTableColumnsChanged")) {
            this.tableModel.setColumns(this._dataModel.getModuleTableColumns());
        } else if (name.equals("searchItemChanged")) {
            ListSelectionModel selModel = this.table.getSelectionModel();
            selModel.clearSelection();
            if (this._dataModel.getSelectedClusteringPair() == null || this._dataModel.getSearchItem() == null) {
                return;
            }
            ArrayList<Vertex> arr = new ArrayList<Vertex>();
            arr.add(this._dataModel.getSearchItem());
            this.highlightRows(selModel, arr);
        } else if (name.equals("selectedVerticesChanged")) {
            ListSelectionModel selModel = this.table.getSelectionModel();
            selModel.clearSelection();
            ArrayList<Vertex> selectedVerts = this._dataModel.getSelectedVertices();
            if (this._dataModel.getSelectedClusteringPair() == null || selectedVerts == null) {
                return;
            }
            this.highlightRows(selModel, selectedVerts);
        } else if (name.equals("selectedClustPairChanged")) {
            Score<Clustering> score = this._dataModel.getSelectedClusteringPair();
            this.tableModel.setScore(score);
            if (score != null) {
                this.detail.setText("Selected: " + ((Clustering)score.getXItem()).getName() + " " + ((Clustering)score.getYItem()).getName());
            } else {
                this.detail.setText("Selected: select clustering pair in ladder");
            }
            this.detail.invalidate();
            this.detail.repaint();
            this.resetSlider();
        } else if (name.equals("metricsScoresChanged")) {
            this.tableModel.setScore(null);
            this.resetSlider();
        }
    }

    private void highlightRows(ListSelectionModel selModel, ArrayList<Vertex> selectedVerts) {
        int row;
        TreeSet<Integer> rows = new TreeSet<Integer>();
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        Score<Clustering> pair = this._dataModel.getSelectedClusteringPair();
        Clustering c = (Clustering)pair.getXItem();
        Collection<Module> mods = c.getModules();
        for (Module m : mods) {
            if (!m.containsAny(selectedVerts)) continue;
            row = this.tableModel.getRowIndex(m);
            rows.add(row);
        }
        c = (Clustering)pair.getYItem();
        mods = c.getModules();
        for (Module m : mods) {
            if (!m.containsAny(selectedVerts)) continue;
            row = this.tableModel.getRowIndex(m);
            rows.add(row);
        }
        Iterator<Module> iterator = rows.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)((Object)iterator.next());
            selModel.addSelectionInterval(r, r);
        }
    }

    private void resetSlider() {
        this.slider.setValue(0);
        this.slider.setUpperValue(100);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int lowerValue = this.slider.getValue();
        int upperValue = this.slider.getUpperValue();
        Color startColor = GradientColorModel.getLadderColor((float)lowerValue / 100.0f, 1.0f, false);
        Color endColor = GradientColorModel.getLadderColor((float)upperValue / 100.0f, 1.0f, false);
        this.slider.setStartColor(startColor);
        this.slider.setEndColor(endColor);
        this.tableModel.setLowerCutoff((float)lowerValue / 100.0f);
        this.tableModel.setUpperCutoff((float)upperValue / 100.0f);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int col = this.table.getSelectedColumn();
        int row = this.table.getSelectedRow();
        if (row < 0 || col < 0) {
            return;
        }
        int adjRow = this.table.convertRowIndexToModel(row);
        int adjCol = this.table.convertColumnIndexToModel(col);
        ModulePair mp = this.tableModel.getRow(adjRow);
        String colName = this.table.getColumnName(adjCol);
        ArrayList<Vertex> value = mp.getValue(colName);
        this._dataModel.removePropertyChangeListener("selectedVerticesChanged", this);
        this._dataModel.setSelectedVertices(value);
        this._dataModel.addPropertyChangeListener("selectedVerticesChanged", this);
    }
}

