/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.tabs;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.ui.control.DiscreteLegend;
import edu.umd.coral.ui.network.NetworkThumbnailPanel;
import edu.umd.coral.ui.panel.MatrixPanel;
import edu.umd.coral.ui.panel.Vertex2VertexPanel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class CooccurrenceMatrixPanel
extends JSplitPane
implements PropertyChangeListener {
    private static final long serialVersionUID = -6127497841545203496L;
    private DataModel _dataModel;
    private JSplitPane top;
    private NetworkThumbnailPanel netView;
    private DiscreteLegend legend;

    public CooccurrenceMatrixPanel(DataModel model) {
        super(0);
        this._dataModel = model;
        model.addPropertyChangeListener("selectedVerticesChanged", this);
        model.addPropertyChangeListener("currentMatrixChanged", this);
        this.setResizeWeight(0.7058823529411765);
        this.top = new JSplitPane(1);
        this.top.setResizeWeight(1.0);
        this.top.setPreferredSize(new Dimension(750, 600));
        this.top.add(new MatrixPanel(this._dataModel));
        this.setResizeWeight(1.0);
        this.setPreferredSize(new Dimension(750, 600));
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new BoxLayout(sidePanel, 1));
        this.legend = new DiscreteLegend(5);
        this.legend.setAlignmentX(0.0f);
        sidePanel.add(this.legend);
        Vertex2VertexPanel v2v = new Vertex2VertexPanel(this._dataModel);
        v2v.setPreferredSize(new Dimension(150, 500));
        v2v.setAlignmentX(0.0f);
        sidePanel.add(v2v);
        this.top.add(sidePanel);
        this.add(this.top);
        if (this._dataModel.hasEdges()) {
            this.netView = new NetworkThumbnailPanel(this._dataModel);
            this.netView.setPreferredSize(new Dimension(0, 0));
            this.add(this.netView);
        }
    }

    private void updateLegend(int maxValue) {
        this.legend.setMaxValue(maxValue);
        this.legend.revalidate();
    }

    public void propertyChange(PropertyChangeEvent e) {
        ArrayList<Vertex> pair;
        if (e.getPropertyName().equals("currentMatrixChanged")) {
            Matrix m = this._dataModel.getCurrentMatrix();
            if (m != null) {
                this.updateLegend((int)m.getMax());
            }
        } else if (e.getPropertyName().equals("selectedVerticesChanged") && (pair = this._dataModel.getSelectedVertices()) != null && this.netView != null) {
            this.netView.setPreferredSize(new Dimension(600, 100));
            this.validate();
            this.repaint();
        }
    }
}

