/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.table.renderer;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Cooccurrence;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class HistogramCellRenderer
extends JComponent
implements TableCellRenderer {
    private Border unselectedBorder = null;
    private Border selectedBorder = null;
    private boolean isBordered = true;
    private int borderThickness = 1;
    private Cooccurrence cooccur;
    private int spacing = 1;
    private int nullHeight = 3;
    private static final long serialVersionUID = -3120175049864772172L;

    public HistogramCellRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object signature, boolean isSelected, boolean hasFocus, int row, int column) {
        this.cooccur = (Cooccurrence)signature;
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(this.borderThickness, this.borderThickness, this.borderThickness, this.borderThickness, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        this.setBackground(Color.WHITE);
        return this;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.cooccur == null) {
            return;
        }
        String signature = this.cooccur.getSignature();
        if (signature == null) {
            return;
        }
        int x = this.spacing;
        int oneHeight = this.getHeight();
        int length = signature.length();
        int columnWidth = (int)Math.floor(((double)this.getWidth() * 1.0 - (double)(2 * this.spacing * length)) / (double)length);
        if (columnWidth <= 0) {
            columnWidth = 1;
        }
        int i = 0;
        while (i < length) {
            String s = signature.substring(i, i + 1);
            Clustering c = this.cooccur.getClusteringAt(i);
            if (c != null) {
                g.setColor(c.getColor());
            }
            if (s.equals("0")) {
                g.fillRect(x, oneHeight - this.nullHeight, columnWidth, this.nullHeight);
            } else if (s.equals("1")) {
                g.fillRect(x, 0, columnWidth, oneHeight);
            }
            x += columnWidth + 2 * this.spacing;
            ++i;
        }
    }
}

