/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.slider;

import edu.umd.coral.ui.slider.RangeSlider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

class RangeSliderUI
extends BasicSliderUI {
    private Color rangeColor = Color.GREEN;
    private Rectangle upperThumbRect;
    private boolean upperThumbSelected;
    private transient boolean lowerDragging;
    private transient boolean upperDragging;

    public RangeSliderUI(RangeSlider b) {
        super(b);
    }

    public void installUI(JComponent c) {
        this.upperThumbRect = new Rectangle();
        super.installUI(c);
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener();
    }

    protected ChangeListener createChangeListener(JSlider slider) {
        return new ChangeHandler();
    }

    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    protected void calculateThumbLocation() {
        int upperPosition;
        super.calculateThumbLocation();
        if (this.slider.getSnapToTicks()) {
            int upperValue;
            int snappedValue = upperValue = this.slider.getValue() + this.slider.getExtent();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((upperValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(upperValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != upperValue) {
                    this.slider.setExtent(snappedValue - this.slider.getValue());
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            upperPosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = upperPosition - this.upperThumbRect.width / 2;
            this.upperThumbRect.y = this.trackRect.y;
        } else {
            upperPosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = this.trackRect.x;
            this.upperThumbRect.y = upperPosition - this.upperThumbRect.height / 2;
        }
    }

    protected Dimension getThumbSize() {
        return new Dimension(12, 12);
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Rectangle clipRect = g.getClipBounds();
        if (this.upperThumbSelected) {
            if (clipRect.intersects(this.thumbRect)) {
                this.paintLowerThumb(g);
            }
            if (clipRect.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(g);
            }
        } else {
            if (clipRect.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(g);
            }
            if (clipRect.intersects(this.thumbRect)) {
                this.paintLowerThumb(g);
            }
        }
    }

    public void paintTrack(Graphics g) {
        super.paintTrack(g);
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int lowerX = this.thumbRect.x + this.thumbRect.width / 2;
            int upperX = this.upperThumbRect.x + this.upperThumbRect.width / 2;
            int cy = trackBounds.height / 2 - 2;
            if (((RangeSlider)this.slider).isDrawGradient()) {
                GradientPaint gradient = new GradientPaint(lowerX - trackBounds.x, 0.0f, ((RangeSlider)this.slider).getStartColor(), upperX - trackBounds.x, 3.0f, ((RangeSlider)this.slider).getEndColor());
                ((Graphics2D)g).setPaint(gradient);
            } else {
                g.setColor(this.rangeColor);
            }
            g.fillRect(lowerX, trackBounds.y + cy, upperX - lowerX, 3);
        } else {
            int lowerY = this.thumbRect.y + this.thumbRect.height / 2;
            int upperY = this.upperThumbRect.y + this.upperThumbRect.height / 2;
            int cx = trackBounds.width / 2 - 2;
            if (((RangeSlider)this.slider).isDrawGradient()) {
                GradientPaint gradient = new GradientPaint(trackBounds.x + cx, upperY, ((RangeSlider)this.slider).getStartColor(), trackBounds.x + cx + 3, lowerY, ((RangeSlider)this.slider).getEndColor());
                ((Graphics2D)g).setPaint(gradient);
            } else {
                g.setColor(this.rangeColor);
            }
            g.fillRect(trackBounds.x + cx, upperY, 3, lowerY - upperY);
        }
    }

    public void paintThumb(Graphics g) {
    }

    private void paintLowerThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        int w = knobBounds.width;
        int h = knobBounds.height;
        Graphics2D g2d = (Graphics2D)g.create();
        Shape thumbShape = this.createThumbShape(w - 1, h - 1);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(knobBounds.x, knobBounds.y);
        g2d.setColor(Color.CYAN);
        g2d.fill(thumbShape);
        g2d.setColor(Color.BLUE);
        g2d.draw(thumbShape);
        g2d.dispose();
    }

    private void paintUpperThumb(Graphics g) {
        Rectangle knobBounds = this.upperThumbRect;
        int w = knobBounds.width;
        int h = knobBounds.height;
        Graphics2D g2d = (Graphics2D)g.create();
        Shape thumbShape = this.createThumbShape(w - 1, h - 1);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(knobBounds.x, knobBounds.y);
        g2d.setColor(Color.PINK);
        g2d.fill(thumbShape);
        g2d.setColor(Color.RED);
        g2d.draw(thumbShape);
        g2d.dispose();
    }

    private Shape createThumbShape(int width, int height) {
        Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, width, height);
        return shape;
    }

    private void setUpperThumbLocation(int x, int y) {
        Rectangle upperUnionRect = new Rectangle();
        upperUnionRect.setBounds(this.upperThumbRect);
        this.upperThumbRect.setLocation(x, y);
        SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, upperUnionRect);
        this.slider.repaint(upperUnionRect.x, upperUnionRect.y, upperUnionRect.width, upperUnionRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int delta = 1 * (direction > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent arg0) {
            if (!RangeSliderUI.this.lowerDragging && !RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.calculateThumbLocation();
                RangeSliderUI.this.slider.repaint();
            }
        }
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super(RangeSliderUI.this);
        }

        public void mousePressed(MouseEvent e) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (RangeSliderUI.this.slider.isRequestFocusEnabled()) {
                RangeSliderUI.this.slider.requestFocus();
            }
            boolean lowerPressed = false;
            boolean upperPressed = false;
            if (RangeSliderUI.this.upperThumbSelected) {
                if (RangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    upperPressed = true;
                } else if (RangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    lowerPressed = true;
                }
            } else if (RangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                lowerPressed = true;
            } else if (RangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                upperPressed = true;
            }
            if (lowerPressed) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).thumbRect.x;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = false;
                RangeSliderUI.this.lowerDragging = true;
                return;
            }
            RangeSliderUI.this.lowerDragging = false;
            if (upperPressed) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).upperThumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).upperThumbRect.x;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = true;
                RangeSliderUI.this.upperDragging = true;
                return;
            }
            RangeSliderUI.this.upperDragging = false;
        }

        public void mouseReleased(MouseEvent e) {
            RangeSliderUI.this.lowerDragging = false;
            RangeSliderUI.this.upperDragging = false;
            RangeSliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (RangeSliderUI.this.lowerDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb();
            } else if (RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        public boolean shouldScroll(int direction) {
            return false;
        }

        private void moveLowerThumb() {
            int thumbMiddle = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int trackBottom = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int vMax = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    RangeSliderUI.this.setThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int trackRight = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int hMax = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    RangeSliderUI.this.setThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void moveUpperThumb() {
            int thumbMiddle = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int trackBottom = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int vMin = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackTop = vMin;
                    } else {
                        trackBottom = vMin;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    RangeSliderUI.this.setUpperThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForYPosition(thumbMiddle) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int trackRight = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int hMin = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackRight = hMin;
                    } else {
                        trackLeft = hMin;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    RangeSliderUI.this.setUpperThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForXPosition(thumbMiddle) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }
}

