/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.slider;

import edu.umd.coral.ui.slider.RangeSlider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RangeSliderDemo
extends JPanel {
    private static final long serialVersionUID = -4149875703426859488L;
    private JLabel lowerLabel = new JLabel();
    private JLabel lowerValueLabel = new JLabel();
    private JLabel upperLabel = new JLabel();
    private JLabel upperValueLabel = new JLabel();
    private RangeSlider rangeSlider = new RangeSlider();

    public RangeSliderDemo() {
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        this.lowerLabel.setText("Lower value:");
        this.upperLabel.setText("Upper value:");
        this.lowerValueLabel.setHorizontalAlignment(2);
        this.upperValueLabel.setHorizontalAlignment(2);
        this.rangeSlider.setOrientation(1);
        this.rangeSlider.setDrawGradient(true);
        this.rangeSlider.setPreferredSize(new Dimension(240, this.rangeSlider.getPreferredSize().height));
        this.rangeSlider.setMinimum(0);
        this.rangeSlider.setMaximum(10);
        this.rangeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RangeSlider slider = (RangeSlider)e.getSource();
                RangeSliderDemo.this.lowerValueLabel.setText(String.valueOf(slider.getValue()));
                RangeSliderDemo.this.upperValueLabel.setText(String.valueOf(slider.getUpperValue()));
            }
        });
        this.add((Component)this.lowerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.lowerValueLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.upperLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.upperValueLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.add((Component)this.rangeSlider, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void display() {
        this.rangeSlider.setValue(3);
        this.rangeSlider.setUpperValue(7);
        this.lowerValueLabel.setText(String.valueOf(this.rangeSlider.getValue()));
        this.upperValueLabel.setText(String.valueOf(this.rangeSlider.getUpperValue()));
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setResizable(false);
        frame.setTitle("Range Slider Demo");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)this, "Center");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new RangeSliderDemo().display();
            }
        });
    }
}

