/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.slider;

import edu.umd.coral.model.GradientColorModel;
import edu.umd.coral.ui.slider.RangeSliderUI;
import java.awt.Color;
import javax.swing.JSlider;

public class RangeSlider
extends JSlider {
    private static final long serialVersionUID = -6911210572427014201L;
    private Color startColor = GradientColorModel.getLadderColor(0.0f, 1.0f, false);
    private Color endColor = GradientColorModel.getLadderColor(1.0f, 1.0f, false);
    private boolean drawGradient = false;

    public RangeSlider() {
    }

    public RangeSlider(int min, int max) {
        super(min, max);
    }

    public void updateUI() {
        this.setUI(new RangeSliderUI(this));
        this.updateLabelUIs();
    }

    public int getValue() {
        return super.getValue();
    }

    public void setValue(int value) {
        int oldValue = this.getValue();
        if (oldValue == value) {
            return;
        }
        int oldExtent = this.getExtent();
        int newValue = Math.min(Math.max(this.getMinimum(), value), oldValue + oldExtent);
        int newExtent = oldExtent + oldValue - newValue;
        this.getModel().setRangeProperties(newValue, newExtent, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    public int getUpperValue() {
        return this.getValue() + this.getExtent();
    }

    public void setUpperValue(int value) {
        int lowerValue = this.getValue();
        int newExtent = Math.min(Math.max(0, value - lowerValue), this.getMaximum() - lowerValue);
        this.setExtent(newExtent);
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
        this.invalidate();
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
        this.invalidate();
    }

    public boolean isDrawGradient() {
        return this.drawGradient;
    }

    public void setDrawGradient(boolean b) {
        this.drawGradient = b;
        this.invalidate();
    }
}

