/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.ui.panel.HasSaveableImage;
import edu.umd.coral.ui.panel.ZoomablePanel;
import edu.umd.coral.ui.tabs.PPDataModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomableParallelSets
extends ZoomablePanel
implements HasSaveableImage {
    private static final long serialVersionUID = -747286996950904094L;
    private final int pixelsPerVertex = 3;
    private int largestClustSize = 0;
    private BufferedImage traces;
    private boolean showItemLabels = true;
    private boolean showPartitionLabels = true;
    private List<ArrayList<Module>> orderings;
    private ArrayList<Clustering> clustCollection;
    private Collection<Vertex> selectedVertices;
    private int moduleSpacing = 6;
    private final int bandSpacing = 50;
    private final int cHeight = 20;
    private final int MIN_WIDTH = 100;
    private final int MIN_MOD_WIDTH = 3;
    private BufferedImage[] clusteringBandImage;
    private BufferedImage[] intersectionBandImage;
    private BufferedImage itemLabelsImage;
    private ArrayList<Vertex> highlightedVertices;
    private PPDataModel ppdm;
    private int avgLabelWidth = 0;

    public ZoomableParallelSets(PPDataModel ppdm) {
        this.setLayout(null);
        this.ppdm = ppdm;
        this.setMinimumSize(new Dimension(this.width / 2, this.height / 2));
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        Dimension d2 = this.updateMatrixSize();
        int w = Math.max(d2.width, d.width);
        int h = Math.max(d2.height, d.height);
        return new Dimension(w, h);
    }

    @Override
    protected Dimension updateMatrixSize() {
        int actualSize = (int)Math.max(100.0f, (float)this.largestClustSize * this.scale);
        int count = this.clustCollection == null ? 1 : this.clustCollection.size();
        int w = actualSize;
        int h = 20 * count + 50 * (count - 1) + 15;
        Dimension preferred = new Dimension(w, h);
        return preferred;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g instanceof Graphics2D) {
            int i;
            int y;
            Graphics2D g2D = (Graphics2D)g;
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rh.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2D.setRenderingHints(rh);
            if (this.getWidth() == 0 || this.getHeight() == 0) {
                return;
            }
            AffineTransform translateAT = AffineTransform.getTranslateInstance(this.translateX, this.translateY);
            AffineTransform scaleAT = AffineTransform.getScaleInstance(this.scale, this.scale);
            scaleAT.concatenate(translateAT);
            FontMetrics fm = g2D.getFontMetrics();
            if (this.clusteringBandImage != null) {
                int labelY = 0;
                y = 0;
                i = 0;
                while (i < this.clusteringBandImage.length) {
                    translateAT = AffineTransform.getTranslateInstance(0.0, y);
                    AffineTransform shear = AffineTransform.getScaleInstance(this.scale, 1.0);
                    shear.concatenate(translateAT);
                    g2D.drawImage(this.clusteringBandImage[i], shear, null);
                    y += 70;
                    if (this.showPartitionLabels) {
                        Clustering c = this.clustCollection.get(i);
                        g2D.setColor(Color.BLACK);
                        Rectangle2D bounds = fm.getStringBounds(c.getName(), g2D);
                        g2D.drawString(c.getName(), 10, labelY + (int)(20.0 + bounds.getHeight()) / 2 - 3 + 20);
                    }
                    labelY += 70;
                    ++i;
                }
            }
            if (this.intersectionBandImage != null) {
                y = 21;
                i = 0;
                while (i < this.intersectionBandImage.length) {
                    translateAT = AffineTransform.getTranslateInstance(0.0, y);
                    scaleAT = AffineTransform.getScaleInstance(this.scale, 1.0);
                    translateAT.concatenate(scaleAT);
                    g2D.drawImage(this.intersectionBandImage[i], translateAT, null);
                    y += 70;
                    ++i;
                }
            }
            if (this.traces != null) {
                g.setColor(Color.RED);
                scaleAT = AffineTransform.getScaleInstance(this.scale, 1.0);
                g2D.drawImage(this.traces, scaleAT, null);
            }
            if (3.0f * this.scale * 3.0f > (float)this.avgLabelWidth && this.showItemLabels) {
                Rectangle r = this.getVisibleRect();
                g2D.drawImage((Image)this.itemLabelsImage, r.x, r.y, null);
            }
        }
    }

    private void drawLabels(Rectangle r) {
        if (r.width < 1 && r.height < 1) {
            return;
        }
        if (this.orderings == null) {
            return;
        }
        this.itemLabelsImage = new BufferedImage(r.width, r.height, 2);
        Graphics2D g2d = this.itemLabelsImage.createGraphics();
        g2d.setColor(Color.BLUE.darker());
        Font font = new Font("SansSerif", 0, 9);
        g2d.setFont(font);
        boolean found_module = false;
        double v = 0.0;
        float labelX = 0.0f;
        int diff_y = 0;
        int band_i = (int)Math.ceil((double)r.y * 1.0 / 70.0);
        float labelY = band_i * 70 - r.y;
        while (labelY < (float)(r.y + r.height) && band_i < this.orderings.size()) {
            ArrayList<Module> modules = this.orderings.get(band_i);
            Module m = modules.get(0);
            labelX = 0.0f;
            int module_j = 0;
            diff_y = 0;
            found_module = false;
            while (labelX < (float)r.x && !found_module) {
                m = modules.get(module_j);
                float x_module_len = (float)(m.getSize() * 3) * this.scale;
                if (labelX + x_module_len > (float)r.x) {
                    v = Math.ceil(((float)r.x - labelX) / (3.0f * this.scale));
                    labelX = (float)((double)labelX + v * 3.0 * (double)this.scale);
                    diff_y = (int)((double)diff_y + v);
                    found_module = true;
                    continue;
                }
                labelX += (float)(m.getSize() * 3 + this.moduleSpacing) * this.scale;
                diff_y += m.getSize();
                ++module_j;
            }
            if (m == null) {
                labelY += 70.0f;
                continue;
            }
            labelX -= (float)r.x;
            diff_y = diff_y % 2 == 0 ? 0 : 8;
            while (module_j < modules.size()) {
                m = modules.get(module_j);
                while (v < (double)m.getSize()) {
                    Vertex u = m.getVertexMapping()[(int)v];
                    g2d.drawString(u.getName(), labelX + 1.0f, labelY + 11.0f + (float)diff_y);
                    diff_y = diff_y == 0 ? 8 : 0;
                    labelX += 3.0f * this.scale;
                    v += 1.0;
                }
                v = 0.0;
                labelX += (float)this.moduleSpacing * this.scale;
                ++module_j;
            }
            labelY += 70.0f;
            ++band_i;
        }
    }

    @Override
    public RenderedImage getImage() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.paint(image.getGraphics());
        return image;
    }

    public void setShowPartitionItems(boolean showPItems) {
        this.showItemLabels = showPItems;
        this.repaint();
    }

    public void setShowPartitionLabels(boolean showPLabels) {
        this.showPartitionLabels = showPLabels;
        this.repaint();
    }

    public void setOrderings(List<ArrayList<Module>> orderings) {
        this.orderings = orderings;
        this.intersectionBandImage = null;
        this.itemLabelsImage = null;
        if (orderings != null && orderings.size() > 0) {
            Graphics g = this.getGraphics();
            FontMetrics fm = g.getFontMetrics();
            ArrayList<Module> modules = orderings.get(0);
            double sum_width = 0.0;
            int i = 0;
            for (Module m : modules) {
                for (Vertex v : m.getVertices()) {
                    Rectangle2D r = fm.getStringBounds(v.getName(), g);
                    sum_width += r.getWidth();
                    ++i;
                }
            }
            this.avgLabelWidth = (int)Math.floor(sum_width / (double)i);
        }
        this.repaint();
    }

    public void setCollection(ArrayList<Clustering> axisOrdering) {
        this.clustCollection = axisOrdering;
        this.clusteringBandImage = null;
        this.traces = null;
        this.itemLabelsImage = null;
        this.repaint();
    }

    public void invalidateData() {
        this.drawClusterings();
        this.repaint();
    }

    public void setSelectedVertices(Collection<Vertex> selectedVertices) {
        this.selectedVertices = selectedVertices;
        this.traces = null;
        this.drawTraces(this.orderings, this.clustCollection);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean getModule = e.isShiftDown();
        ArrayList<Module> ordering = this.getClusteringBand(e.getY());
        if (ordering != null) {
            this.selectedVertices = this.getItems(ordering, getModule, e.getX());
            this.ppdm.setSelectedVertices(this.highlightedVertices);
            this.drawTraces(this.orderings, this.clustCollection);
            this.repaint();
            return;
        }
        this.highlightedVertices = null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean getModule = e.isShiftDown();
        ArrayList<Module> ordering = this.getClusteringBand(e.getY());
        if (ordering == null) {
            this.setToolTipText(null);
            return;
        }
        if (getModule) {
            Module m = this.getModule(ordering, e.getX());
            if (m != null) {
                this.setToolTipText("<html>Module: <b>" + m.getName() + "</b> (" + m.getSize() + ")<br>" + "clustering: <b>" + m.getClustering().getName() + "</b><br>" + "</html>");
            } else {
                this.setToolTipText(null);
            }
        } else {
            Module m = null;
            Vertex v = null;
            boolean isFound = false;
            int xxx = 0;
            int i = 0;
            while (i < ordering.size() && !isFound) {
                m = ordering.get(i);
                if (xxx <= e.getX() && (float)e.getX() < (float)xxx + (float)(m.getSize() * 3) * this.scale) {
                    int index = (int)Math.floor((float)(e.getX() - xxx) / (3.0f * this.scale));
                    v = m.getVertexMapping()[index];
                    isFound = true;
                }
                xxx = (int)((float)xxx + (float)(m.getSize() * 3 + this.moduleSpacing) * this.scale);
                ++i;
            }
            if (v != null) {
                this.setToolTipText("<html>Item: " + v.getName() + "<br>" + "module: <b>" + m.getName() + "</b> (" + m.getSize() + ")<br>" + "clustering: <b>" + m.getClustering().getName() + "</b><br>" + "</html>");
            } else {
                this.setToolTipText(null);
            }
        }
    }

    private Module getModule(ArrayList<Module> ordering, int x) {
        int xxx = 0;
        int i = 0;
        while (i < ordering.size()) {
            Module m = ordering.get(i);
            if (xxx <= x && (float)x < (float)xxx + (float)(m.getSize() * 3) * this.scale) {
                return m;
            }
            xxx = (int)((float)xxx + (float)(m.getSize() * 3 + this.moduleSpacing) * this.scale);
            ++i;
        }
        return null;
    }

    private ArrayList<Module> getClusteringBand(int y) {
        if (this.clustCollection == null) {
            return null;
        }
        boolean found = false;
        Iterator<Clustering> iter = this.clustCollection.iterator();
        int y_coord = 0;
        int i = 0;
        while (!found && iter.hasNext()) {
            if (y_coord <= y && y < y_coord + 20) {
                found = true;
                continue;
            }
            y_coord += 70;
            ++i;
            iter.next();
        }
        if (found && this.orderings != null) {
            return this.orderings.get(i);
        }
        return null;
    }

    private ArrayList<Vertex> getItems(ArrayList<Module> ordering, boolean getModule, int x) {
        int index = 0;
        int xxx = 0;
        int i = 0;
        while (i < ordering.size()) {
            Module m = ordering.get(i);
            if (xxx <= x && (float)x < (float)xxx + (float)(m.getSize() * 3) * this.scale) {
                if (getModule) {
                    this.highlightedVertices = m.getVertices();
                } else {
                    this.highlightedVertices = new ArrayList();
                    index = (int)Math.floor((float)(x - xxx) / (3.0f * this.scale));
                    this.highlightedVertices.add(m.getVertexMapping()[index]);
                }
                return this.highlightedVertices;
            }
            xxx = (int)((float)xxx + (float)(m.getSize() * 3 + this.moduleSpacing) * this.scale);
            ++i;
        }
        return null;
    }

    private void drawClusterings() {
        if (this.clustCollection == null || this.clustCollection.size() == 0) {
            this.traces = null;
            this.repaint();
            return;
        }
        this.largestClustSize = 0;
        int pxLength = 10;
        int maxModuleCount = 0;
        int maxVertexCount = 0;
        for (Clustering c : this.clustCollection) {
            if (maxModuleCount < c.getModuleCount()) {
                maxModuleCount = c.getModuleCount();
            }
            if (maxVertexCount < c.getVertexCount()) {
                maxVertexCount = c.getVertexCount();
            }
            if (this.largestClustSize >= (pxLength = c.getVertexCount() + (c.getModuleCount() - this.moduleSpacing))) continue;
            this.largestClustSize = pxLength;
        }
        Dimension size = this.getSize();
        int w = (int)size.getWidth();
        int h = (int)size.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        this.drawClusteringBands(this.orderings, this.clustCollection);
        this.drawIntersectionBands(this.orderings, this.clustCollection);
        this.drawTraces(this.orderings, this.clustCollection);
    }

    private void drawTraces(List<ArrayList<Module>> orderings, ArrayList<Clustering> clusterings) {
        if (orderings == null || this.selectedVertices == null) {
            return;
        }
        int count = clusterings.size();
        int w = this.largestClustSize;
        int h = (int)Math.ceil(count * 20 + (count - 1) * 50);
        this.traces = new BufferedImage(w, h, 2);
        Graphics2D imageGraphics = this.traces.createGraphics();
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rh.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        imageGraphics.setRenderingHints(rh);
        int x1 = 0;
        int x2 = 0;
        int index = -1;
        int y = 0;
        int s = clusterings.size();
        BasicStroke stroke = new BasicStroke(2.0f);
        imageGraphics.setStroke(stroke);
        Color color = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 70);
        imageGraphics.setColor(color);
        for (Vertex v : this.selectedVertices) {
            y = 20;
            int c = 0;
            while (c < s - 1) {
                ArrayList<Module> ordering1 = orderings.get(c);
                ArrayList<Module> ordering2 = orderings.get(c + 1);
                x1 = 0;
                for (Module m : ordering1) {
                    if (!m.contains(v)) {
                        x1 += m.getSize() * 3 + this.moduleSpacing;
                        continue;
                    }
                    index = m.getIndex(v);
                    x1 += 3 * index + 1;
                    break;
                }
                if (c == 0) {
                    imageGraphics.drawLine(x1, 0, x1, y);
                }
                index = -1;
                x2 = 0;
                for (Module m : ordering2) {
                    if (!m.contains(v)) {
                        x2 += m.getSize() * 3 + this.moduleSpacing;
                        continue;
                    }
                    index = m.getIndex(v);
                    x2 += 3 * index + 1;
                    break;
                }
                imageGraphics.drawLine(x1, y, x2, y + Math.round(50.0f));
                imageGraphics.drawLine(x2, y + Math.round(50.0f), x2, y + 20 + Math.round(50.0f));
                y += 70;
                ++c;
            }
        }
    }

    private void drawIntersectionBands(List<ArrayList<Module>> moduleOrderings, ArrayList<Clustering> clusteringOrdering) {
        if (moduleOrderings == null) {
            return;
        }
        int bandsCount = clusteringOrdering.size() - 1;
        this.intersectionBandImage = new BufferedImage[bandsCount];
        int y = 0;
        int j = 0;
        while (j < bandsCount) {
            int x = 0;
            ArrayList<Module> ordering1 = moduleOrderings.get(j);
            ArrayList<Module> ordering2 = moduleOrderings.get(j + 1);
            int[] x2 = new int[ordering2.size()];
            int i = 0;
            int offset = 0;
            for (Module m2 : ordering2) {
                x2[i++] = offset;
                offset += this.getModuleWidth(m2) + this.moduleSpacing;
            }
            Color c = clusteringOrdering.get(j).getColor();
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 50);
            int clustWidth = this.calculateClusteringWidth(clusteringOrdering.get(j), 3.0f);
            int clustWidth2 = this.calculateClusteringWidth(clusteringOrdering.get(j + 1), 3.0f);
            clustWidth = Math.max(clustWidth, clustWidth2);
            this.intersectionBandImage[j] = new BufferedImage(clustWidth, 50, 2);
            Graphics2D imageGraphics = this.intersectionBandImage[j].createGraphics();
            imageGraphics.setColor(c);
            for (Module m1 : ordering1) {
                i = 0;
                for (Module m2 : ordering2) {
                    int[][] indices = m1.getIntersectionIndices(m2);
                    int s = indices.length;
                    if (s > 0) {
                        int k = 0;
                        while (k < s) {
                            int[] xPoints = new int[]{x + (int)Math.ceil(3 * indices[k][0]), x + (int)Math.ceil(3 * (indices[k][0] + 1)), x2[i] + (int)Math.ceil(3 * (indices[k][1] + 1)), x2[i] + (int)Math.ceil(3 * indices[k][1])};
                            int[] yPoints = new int[]{y, y, y + 50, y + 50};
                            imageGraphics.fillPolygon(xPoints, yPoints, 4);
                            ++k;
                        }
                    }
                    ++i;
                }
                x += this.getModuleWidth(m1) + this.moduleSpacing;
            }
            ++j;
        }
    }

    private void drawClusteringBands(List<ArrayList<Module>> moduleOrderings, List<Clustering> clusteringOrdering) {
        if (moduleOrderings == null) {
            return;
        }
        int count = clusteringOrdering.size();
        this.clusteringBandImage = new BufferedImage[count];
        int longestClustering = 0;
        int v_y = 0;
        int c = 0;
        while (c < count) {
            Clustering clust = clusteringOrdering.get(c);
            int cWidth = this.calculateClusteringWidth(clust, 3.0f);
            if (cWidth > longestClustering) {
                longestClustering = cWidth;
            }
            this.clusteringBandImage[c] = new BufferedImage(cWidth, 23, 2);
            Graphics2D imageGraphics = this.clusteringBandImage[c].createGraphics();
            ArrayList<Module> ordering = moduleOrderings.get(c);
            assert (ordering != null);
            int x = 0;
            for (Module m : ordering) {
                if (m.getName().equals("__misc__")) {
                    imageGraphics.setColor(Color.LIGHT_GRAY);
                } else {
                    imageGraphics.setColor(clust.getColor());
                }
                int v = 0;
                while (v < m.getSize()) {
                    imageGraphics.fillRect(x + v * 3, v_y, 3, 20);
                    v_y = v_y == 2 ? 0 : 2;
                    ++v;
                }
                x += m.getSize() * 3 + this.moduleSpacing;
            }
            imageGraphics.setColor(Color.BLACK);
            ++c;
        }
        this.largestClustSize = longestClustering;
    }

    private int calculateClusteringWidth(Clustering clust, float pixelPerVertex) {
        float sum = 0.0f;
        for (Module m : clust.getModules()) {
            float mWidth = pixelPerVertex * (float)m.getSize();
            if (mWidth < 3.0f) {
                sum += 3.0f;
                continue;
            }
            sum += mWidth;
        }
        return (int)(sum += (float)((clust.getModuleCount() - 1) * this.moduleSpacing));
    }

    private int getModuleWidth(Module m) {
        float w = m.getSize() * 3;
        if (w < 3.0f) {
            w = 3.0f;
        }
        return (int)Math.ceil(w);
    }

    public void updateLabels() {
        if (3.0f * this.scale * 3.0f > (float)this.avgLabelWidth && this.showItemLabels) {
            Rectangle r = this.getVisibleRect();
            this.drawLabels(r);
        }
    }

    public void setModuleSpacing(int moduleSpacing) {
        this.moduleSpacing = moduleSpacing;
        this.drawClusterings();
        this.repaint();
    }
}

