/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.ui.JPanelExt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SelectablePanel
extends JPanelExt
implements MouseMotionListener,
MouseListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2322335918777051414L;
    protected Point zoomRegionStart;
    protected Point zoomRegionEnd;
    protected BufferedImage selection;
    protected BufferedImage vertSelection;
    protected String selectionMode = "selectSingleVertex";

    public SelectablePanel(DataModel model) {
        super(model);
        this.setBackground(Color.BLACK);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected AffineTransform getTranslate() {
        if (this.zoomRegionStart != null && this.zoomRegionEnd != null) {
            int minX = (int)Math.min(this.zoomRegionStart.getX(), this.zoomRegionEnd.getX());
            int minY = (int)Math.min(this.zoomRegionStart.getY(), this.zoomRegionEnd.getY());
            return AffineTransform.getTranslateInstance(minX, minY);
        }
        return AffineTransform.getTranslateInstance(0.0, 0.0);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        if (this.selectionMode == "selectMultVertices" && this.vertSelection != null) {
            g2D.drawImage(this.vertSelection, null, null);
            System.out.println("drawing mutl vert");
        } else if (this.selectionMode == "selectSingleVertex") {
            System.out.println("drawing single vert");
        }
    }

    public void mouseClicked(MouseEvent e) {
        System.out.println("mouse clicked");
        this.selectionMode = "selectSingleVertex";
        int clkCount = e.getClickCount();
        if (clkCount == 1) {
            this.selectionMode = "selectSingleVertex";
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
        this.requestFocusInWindow();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        System.out.println("mouse pressed");
        this.requestFocus();
        this.requestFocusInWindow();
        this.flushImage();
        this.zoomRegionStart = e.getPoint();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        System.out.println("mouse released");
        this.flushImage();
        if (this.selectionMode == "selectMultVertices") {
            this.zoomRegionEnd = e.getPoint();
            this.selectVertices(this.zoomRegionStart, this.zoomRegionEnd);
        }
        this.repaint();
    }

    private void selectVertices(Point zoomRegionStart2, Point zoomRegionEnd2) {
    }

    private void flushImage() {
        this.selection = null;
        this.selection = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.vertSelection = null;
        this.vertSelection = new BufferedImage(this.getWidth(), this.getHeight(), 2);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.selectionMode = this._dataModel.getSelectionMode();
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("SimpleTableDemo");
        frame.setDefaultCloseOperation(3);
        DataModel dm = new DataModel(frame);
        SelectablePanel newContentPane = new SelectablePanel(dm);
        newContentPane.setPreferredSize(new Dimension(400, 400));
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectablePanel.createAndShowGUI();
            }
        });
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent arg0) {
    }
}

