/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.ui.JPanelExt;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class PairTextPane
extends JPanelExt
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 7911889871953305636L;
    private int width = 300;
    private int height = 250;
    private JTextField vertField;
    private JComboBox clusterBox;

    public PairTextPane(DataModel model) {
        super(model);
        this.setMinimumSize(new Dimension(this.width / 2, this.height / 2));
        this.setPreferredSize(new Dimension(this.width, this.height));
        model.addPropertyChangeListener("selectedVerticesChanged", this);
        model.addPropertyChangeListener("clusteringsChanged", this);
        model.addPropertyChangeListener("selectedClusteringChanged", this);
        this.add(new JLabel("Selected Vertex Pair\n", 0));
        this.vertField = new JTextField(20);
        this.vertField.setAlignmentX(0.5f);
        this.vertField.setEditable(false);
        this.vertField.setHorizontalAlignment(0);
        this.add(this.vertField);
        this.add(new JLabel("Selected Clustering\n", 0));
        this.clusterBox = new JComboBox();
        this.clusterBox.addItem("");
        this.clusterBox.setSelectedIndex(0);
        this.add(this.clusterBox);
        this.clusterBox.addActionListener(this);
        this.setLayout(new BoxLayout(this, 1));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("selectedVerticesChanged")) {
            if (this._dataModel.getSelectedVertices() == null) {
                this.vertField.setText("");
            } else {
                this.vertField.setText(this._dataModel.getSelectedVertices().toString());
            }
        } else if (name.equals("clusteringsChanged")) {
            this.clusterBox.removeAllItems();
            this.clusterBox.addItem("");
            if (this._dataModel.getClusterings() != null) {
                for (String s : this._dataModel.getClusterings().keySet()) {
                    this.clusterBox.addItem(s);
                }
            }
        } else if (name.equals("selectedClusteringChanged")) {
            Clustering selected = this._dataModel.getSelectedClustering();
            if (selected == null) {
                this.clusterBox.setSelectedItem("");
            } else {
                this.clusterBox.setSelectedItem(this._dataModel.getSelectedClustering().getName());
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        String clusterName = (String)cb.getSelectedItem();
        if (clusterName == null || clusterName.equals("")) {
            this._dataModel.setSelectedClustering(null);
        } else {
            this._dataModel.setSelectedClustering(this._dataModel.getClusterings().get(clusterName));
        }
    }
}

