/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.panel;

import edu.umd.coral.clustering.LAPSwingWorker;
import edu.umd.coral.clustering.ReorderingProgressDialog;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Matrix;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;

public class MatrixPopupMenu
extends JPopupMenu
implements ActionListener {
    private static final long serialVersionUID = -7173525782297146939L;
    private DataModel model;
    private final String REORDER = "Reorder current matrix";

    public MatrixPopupMenu(DataModel model) {
        this.model = model;
        JMenuItem menuItem = new JMenuItem("Reorder current matrix");
        menuItem.addActionListener(this);
        this.add(menuItem);
    }

    public void actionPerformed(ActionEvent ev) {
        JMenuItem source = (JMenuItem)ev.getSource();
        String text = source.getText();
        if (text.equals("Reorder current matrix")) {
            int greedy = this.model.getMatrixGreedyIterations();
            int opt = this.model.getMatrixOptIterations();
            JFrame frame = this.model.getMainWindow();
            final ReorderingProgressDialog dialog = new ReorderingProgressDialog(frame);
            Matrix localMatrix = this.model.getCurrentMatrix();
            final LAPSwingWorker lapWorker = new LAPSwingWorker(localMatrix, dialog, greedy, opt);
            dialog.cancelBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("Attempting to cancel reordering");
                    lapWorker.cancel(true);
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            lapWorker.addPropertyChangeListener(dialog);
            lapWorker.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("state") && e.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                        LAPSwingWorker lapWorker = (LAPSwingWorker)e.getSource();
                        try {
                            Matrix m = (Matrix)lapWorker.get();
                            dialog.setVisible(false);
                            dialog.dispose();
                            MatrixPopupMenu.this.model.setCurrentMatrix(m);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        catch (ExecutionException e1) {
                            e1.printStackTrace();
                        }
                        catch (CancellationException e1) {
                            System.out.println("Got a cancellation exception");
                            lapWorker.done();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        MatrixPopupMenu.this.setVisible(false);
                    }
                }
            });
            this.setVisible(false);
            dialog.pack();
            Point p = frame.getLocationOnScreen();
            Rectangle r = frame.getBounds();
            Dimension d = dialog.getPreferredSize();
            int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
            int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
            dialog.setLocation(x, y);
            lapWorker.execute();
            dialog.setVisible(true);
        }
    }
}

