/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.network;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.network.ClusteringListModel;
import edu.umd.coral.ui.network.ClusteringThumb;
import edu.umd.coral.ui.network.ListDataItem;
import edu.umd.coral.ui.network.VertexVisualization;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class NetworkThumbnailPanel
extends JPanelExt
implements PropertyChangeListener {
    private static final long serialVersionUID = -5854156909090998236L;
    private JList list = new JList();
    private ClusteringListModel listModel;
    private VertexVisualization vertexVis;

    public NetworkThumbnailPanel(DataModel model) {
        super(model);
        if (this._dataModel != null) {
            this._dataModel.addPropertyChangeListener("selectedVerticesChanged", this);
            this._dataModel.addPropertyChangeListener("networkLoaded", this);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.list = new JList();
        this.list.setCellRenderer(new ClusteringThumb());
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(1);
        this.list.setSelectionMode(1);
        this.list.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.list.setAlignmentX(0.0f);
        this.list.setAlignmentY(0.0f);
        this.listModel = new ClusteringListModel();
        this.list.setModel(this.listModel);
        JScrollPane pane = new JScrollPane(this.list, 20, 30);
        pane.setAlignmentX(0.0f);
        this.add(pane);
        this.vertexVis = new VertexVisualization();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("networkLoaded")) {
            Map<String, Vertex> map = this._dataModel.getVertices();
            if (map == null) {
                this.vertexVis.initializeGraph(null);
            } else {
                this.vertexVis.initializeGraph(map.values());
            }
        } else if (name.equals("selectedVerticesChanged")) {
            ArrayList<Vertex> selectedPair = this._dataModel.getSelectedVertices();
            if (selectedPair == null) {
                this.listModel.setData((ListDataItem[])null);
                return;
            }
            Map<String, Clustering> map = this._dataModel.getClusterings();
            Collection<Clustering> clusteringsCollection = map.values();
            Object[] clusteringArray = clusteringsCollection.toArray(new Clustering[0]);
            Arrays.sort(clusteringArray);
            int length = clusteringArray.length;
            ListDataItem[] items = new ListDataItem[length];
            int i = 0;
            while (i < length) {
                ListDataItem item;
                items[i] = item = new ListDataItem((Clustering)clusteringArray[i], selectedPair, this.vertexVis);
                ++i;
            }
            this.listModel.setData(items);
            this.list.setModel(this.listModel);
            this.list.invalidate();
        }
    }
}

